# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for The Onion videos.
"""


import re

from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format


__all__ = ("TheOnion",)


class TheOnionMedium(HTMLMedium):

    """A video on The Onion."""

    raw_url_format = "http://www.theonion.com/video/x,%s/"

    def __iter__(self):
        """Iterate formats."""
        yield Format(url=self.get_content_substring(\
                start='var video_url = "', end='";'))


class TheOnion(HTMLPlugin):

    """Plugin for The Onion videos."""

    match_re = re.compile(r"^http://www\.theonion\.com/video/[^,]+,"
                          "(?P<mediumid>\d+)/$")
    medium_class = TheOnionMedium
