# -*- coding: utf-8 -*- #
# Copyright (C) 2008, 2009 Leonardo Gastón De Luca leo[at]kde.org.ar
# Copyright (C) 2010 Osama Khalid osamak[at]gnu.org
# Copyright (C) 2010, 2011  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for Blip.tv videos.
"""


import re

from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format
from getmediumurl.plugin import Plugin
from getmediumurl.xmlhtml import read_xml


__all__ = ("Bliptv", "EmbeddedBliptv")


class BliptvMedium(HTMLMedium):

    """A Blip.tv video."""
    url_format = "http://blip.tv/file/%s"
    website_name = "Blip.tv"

    def __iter__(self):
        """Iterate video formats."""
        yield Format(url=self.get_content_substring(\
                start='MediaUrl("', end='?referrer'))


class Bliptv(HTMLPlugin):

    """Plugin for Blip.tv videos."""

    match_re = re.compile(r'^http://(?:[a-z]+\.)?blip\.tv/file/'
                          r'(?P<mediumid>\d+)')
    raw_url_format = "http://blip.tv/file/%s"
    medium_class = BliptvMedium


_EMBEDDED_RE = re.compile(".*flash%2F(\d+).*")


class EmbeddedBliptv(Plugin):

    """Plugin for Blip.tv embedded videos."""

    raw_url_format = "http://blip.tv/play/%s"
    match_re = re.compile(r'^http://(?:[a-z]+\.)?blip\.tv/play/'
                          r'(?P<mediumid>.+)')

    def __iter__(self):
        """Iterate media."""
        url = self.raw_url_format % self.mediumid
        match = _EMBEDDED_RE.match(self.urlreader(url).url)
        doc = read_xml(self.urlreader("http://blip.tv/rss/flash/"
                                      + match.group(1)).content)
        medium = BliptvMedium(self)
        medium.mediumid = doc.findtext("//item/link").split("/")[-1]
        yield medium
