# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Porno.DD plugin for GetMediumURL."""


import re

from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import SimpleFormat


__all__ = ("PornoDD",)


class PornoDDMedium(HTMLMedium):

    """A video on Porno.DD."""

    raw_url_format = "http://pornodd.com/x/%s/"
    website_name = "Porno.DD"

    @property
    def url(self):
        """Page URL."""
        return "http://pornodd.com/%s/%s/" % (
            self.title.lower().replace(" ", "-"), self.mediumid)

    @property
    def title(self):
        """Video title."""
        return self.get_content_substring('<h1 class="playertit">',
                                          '<span id="verocultar">')

    @property
    def thumbnail(self):
        """Video thumbnail URL."""
        return self.get_content_substring("&amp;image=", ".jpg")

    def __iter__(self):
        """Iterate formats."""
        yield SimpleFormat(url=self.get_content_substring(\
                "&amp;file=", ".flv"))


class PornoDD(HTMLPlugin):

    """Plugin for Porno.DD."""

    match_re = re.compile("^http://pornodd.com/[^/]+/(?P<mediumid>\d+)/$")
    medium_class = PornoDDMedium
