# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Tube8.com plugin for GetMediumURL."""


import urllib2

from getmediumurl.format import SimpleFormat
from getmediumurl.htmlplugin import HTMLPlugin
from getmediumurl.cache import cachedproperty


__all__ = ("Tube8",)


class Tube8(HTMLPlugin):

    """Plugin for Tube8.com."""

    url_format = "http://www.tube8.com/%s/"
    website_name = "Tube8.com"

    @cachedproperty
    def _author_a(self):
        """Element for author profile link."""
        for element in self.page.getiterator("div"):
            if element.get("class") == "cont-col":
                for subelement in element.getiterator("a"):
                    if "user" in subelement.get("href"):
                        return subelement

    @cachedproperty
    def author_name(self):
        """Author profile name."""
        return self._author_a.text

    @cachedproperty
    def author_url(self):
        """Author profile URL."""
        return self._author_a.get("href")

    @cachedproperty
    def description(self):
        """Video description."""
        for element in self.page.getiterator("div"):
            if element.get("class") == "cont-col":
                if element[0].text == u"Description:":
                    return element[0].tail.strip()

    @cachedproperty
    def title(self):
        """Video title."""
        for element in self.page.getiterator("h1"):
            if "main-title" in element.get("class"):
                return element.text

    @cachedproperty
    def thumbnail(self):
        """Video thumnail URL."""
        return self.get_content_substring("flashvars.image_url = \"",
                                          "\";")

    def formats(self):
        """Return an interable of supported medium formats."""
        return (SimpleFormat(urllib2.unquote(self.get_content_substring(\
                        "flashvars.video_url = \"", "\";")),
                             mime_type="video/flv"),)
