# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for Lube Tube videos.
"""


from getmediumurl.cache import cachedproperty
from getmediumurl.htmlplugin import HTMLPlugin
from getmediumurl.xmlhtml import read_xml


__all__ = ("LubeTube",)


class LubeTube(HTMLPlugin):

    """Plugin for Lube Tube videos."""

    url_format = "http://lubetube.com/video/%s"
    website_name = "Lube Tube"

    @cachedproperty
    def _dom(self):
        """XML document describing the video."""
        data = self.get_content_substring("'player.swf','", "','")
        return read_xml(self.urlreader("http://lubetube.com/%s"
                                       % data).content)

    @cachedproperty
    def title(self):
        """Video title."""
        return self._dom.findtext("//title")

    def get_file_url(self, high_quality=False):
        """Return video file URL."""
        return self._dom.findtext("//jwplayer:file")
