// -*- c++ -*- (enables emacs c++ mode)
//========================================================================
//
// Library : Generic Matrix Methods  (gmm)
// File    : gmm_kernel.h : vector and matrices definition + blas
//           
// Date    : November 15, 2003.
// Author  : Yves Renard <Yves.Renard@insa-toulouse.fr>
//
//========================================================================
//
// Copyright (C) 2002-2005 Yves Renard
//
// This file is a part of GETFEM++
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//========================================================================

/**@file gmm_kernel.h 
   @brief Include the base gmm files.
 */

#ifndef GMM_KERNEL_H__
#define GMM_KERNEL_H__

#include <gmm_def.h>
#include <gmm_blas.h>
#include <gmm_real_part.h>
#include <gmm_interface.h>
#include <gmm_sub_vector.h>
#include <gmm_sub_matrix.h>
#include <gmm_vector_to_matrix.h>
#include <gmm_vector.h>
#include <gmm_matrix.h>
#include <gmm_tri_solve.h>
#include <gmm_blas_interface.h>


#endif //  GMM_KERNEL_H__
