disp('3D stokes demonstration on a quadratic mesh -- 512MB of memory needed for the solve!!');
compute=input('  1:compute the solution\n  0:load a previously computed solution\n ? ');
gf_workspace('clear all');
global verbosity; verbosity=1;
clear pde; 
pde.type = 'stokes';
pde.viscos=1.0;
pde.F = {0,0,0};
pde.bound{1}.R  = {'9-(y.^2+(z-6.0).^2)',0,0};
pde.bound{2}.R  = {'9-(y.^2+(z-6.0).^2)',0,0};
pde.bound{3}.R  = {0,0,0};pde.bound{3}.H = {0,0,0;0,0,0;0,0,1};pde.bound{3}.G  = {0,0,0};
pde.bound{4}.R  = {0,0,0};
pde.bound{1}.type = 'Dirichlet';
pde.bound{2}.type = 'Dirichlet';
%pde.bound{3}.type = 'Mixed'; 
pde.bound{3}.type = 'Dirichlet';
pde.bound{4}.type = 'Dirichlet';

m=gf_mesh('import','GiD','tank_quadratic_2500.GiD.msh');
pde.mf_u=gf_mesh_fem(m,3);
mfulag=gf_mesh_fem(m,3);
pde.mf_p=gf_mesh_fem(m,1);
pde.mf_d=gf_mesh_fem(m,1);
% this is a good example of the usefullness of the cubic bubble
% -> if not used, the pression has strange values
%gf_mesh_fem_set(pde.mf_u,'fem',gf_fem('FEM_PK_WITH_CUBIC_BUBBLE(3,2)'),
%gf_integ('IM_TETRAHEDRON(5)'));
%gf_mesh_fem_set(pde.mf_u,'fem',gf_fem('FEM_PK_WITH_CUBIC_BUBBLE(3,2)'), gf_integ('IM_TETRAHEDRON(5)'));
gf_mesh_fem_set(pde.mf_u,'fem',gf_fem('FEM_PK(3,2)'), gf_integ('IM_TETRAHEDRON(5)'));
gf_mesh_fem_set(pde.mf_d,'fem',gf_fem('FEM_PK(3,2)'), gf_integ('IM_TETRAHEDRON(5)'));
gf_mesh_fem_set(pde.mf_p,'fem',gf_fem('FEM_PK(3,1)'), gf_integ('IM_TETRAHEDRON(1)'));

% we use a P3 mesh fem for interpolation of the U field, since
% because of its cubic bubble function, the pde.mf_u is not lagrangian 
gf_mesh_fem_set(mfulag,'fem',gf_fem('FEM_PK(3,1)'), gf_integ('IM_TETRAHEDRON(5)'));
all_faces = gf_mesh_get(m, 'outer faces', gf_mesh_get(m, 'cvid'));

P=gf_mesh_get(m,'pts');
INpid=find(abs(P(1,:)+25) < 1e-4);
OUTpid=find(abs(P(1,:)-25) < 1e-4);
TOPpid=find(abs(P(3,:)-20) < 1e-4);
INfaces=gf_mesh_get(m, 'faces from pid', INpid);
OUTfaces=gf_mesh_get(m, 'faces from pid', OUTpid);
TOPfaces=gf_mesh_get(m, 'faces from pid', TOPpid);
for mf=[pde.mf_u pde.mf_p pde.mf_d],
  gf_mesh_fem_set(mf, 'boundary', 1, INfaces);
  gf_mesh_fem_set(mf, 'boundary', 2, OUTfaces);
  gf_mesh_fem_set(mf, 'boundary', 3, TOPfaces);
  gf_mesh_fem_set(mf, 'boundary', 4, setdiff(all_faces',union(union(INfaces',OUTfaces','rows'),TOPfaces','rows'),'rows')');
end;
disp(sprintf('nbdof: mf_u=%d, mf_p=%d',gf_mesh_fem_get(pde.mf_u,'nbdof'),gf_mesh_fem_get(pde.mf_p,'nbdof')));
if (compute),
  % unfortunately, the basic stokes solver is very slow...
  % on this problem, the fastest way is to reduce to a (full) linear system on the pression...
  % drawback: matlab will be killed if you don't have 512MB of memory
  pde.solver = 'brute_stokes'; 
  tic; [U,P]=gf_solve(pde); disp(sprintf('solve done in %.2f sec', toc));
  save demo_stokes_3D_tank_UP U P;
  disp('[the solution has been saved in "demo_stokes_3D_tank_UP.mat"]');
else
  load demo_stokes_3D_tank_UP;
end;

disp('Got a solution, now you can call demo_stokes_3D_tank_draw to generate graphics');


if (0)
  figure(1);
sl=gf_slice({'boundary',{'intersection',{'planar',+1,[0;0;0],[0;1;0]},{'planar',+1,[0;0;0],[1;0;0]}}},m,6);
Usl=gf_compute(pde.mf_u,U,'interpolate on', sl);
Psl=gf_compute(pde.mf_p,P,'interpolate on', sl);
gf_plot_slice(sl,'mesh_faces','on','mesh','on','data',sqrt(sum(Usl.^2,1)),'mesh_slice_edges','off'); camlight;

sl=gf_slice({'boundary',{'intersection',{'planar',+1,[0;0;6],[0;0;-1]},{'planar',+1,[0;0;0],[0;1;0]}}},m,6);
Usl=gf_compute(pde.mf_u,U,'interpolate on', sl);
Psl=gf_compute(pde.mf_p,P,'interpolate on', sl);
hold on;gf_plot_slice(sl,'mesh_faces','on','mesh','on','data',sqrt(sum(Usl.^2,1)),'mesh_slice_edges','off'); hold off;
  
  
sl2=gf_slice({'boundary',{'planar',+1,[0;0;0],[0;1;0]}},m,6,setdiff(all_faces',TOPfaces','rows')');
hold on; gf_plot_slice(sl2,'mesh_faces','on','mesh','on'); hold off;

%P=[0 8.5;    2.5 6;   0 3.8; 0 6.5];
hh=[1 5 9 12.5 16 19.5];
tsl=cell(0);
for i=hh,
  tsl=gf_slice(m,'streamline',pde.mf_u,U,[0;0;i]);
  Utsl=gf_compute(pde.mf_u,U,'interpolate on', tsl);
  hold on; [a,h]=gf_plot_slice(tsl,'data',Utsl(1,:),'tube_radius',.2); hold off;
end;



  figure(2);
  sl=gf_slice(m,{'boundary',{'intersection',{'planar',+1,[0;0;6],[0;0;-1]},{'planar',+1,[0;0;0],[0;1;0]}}},6);
  Usl=gf_compute(pde.mf_u,U,'interpolate on', sl);
  Psl=gf_compute(pde.mf_p,P,'interpolate on', sl);
  gf_plot_slice(sl,'mesh_faces','on','mesh','on','data',sqrt(sum(Usl.^2,1)),'mesh_slice_edges','off'); camlight;
  hold on; gf_plot_slice(sl2,'mesh_faces','on','mesh','on'); hold off;
  
  ww=[0 3 6 9 12 15 18];
  for i=ww,
    tsl=gf_slice(m,'streamline',pde.mf_u,U,[0;i;11]);
    Utsl=gf_compute(pde.mf_u,U,'interpolate on', tsl);
    hold on; [a,h]=gf_plot_slice(tsl,'data',Utsl(1,:),'tube_radius',.2); hold off;
  end;
end;
