#!/bin/sh
echo "running checks..."
echo "  setenv MATLAB_ROOT $MATLAB_ROOT"
echo "  setenv MATLABPATH $MATLABPATH"
echo "  setenv LD_LIBRARY_PATH $LD_LIBRARY_PATH"
# the MATLABPATH is set here again in order to override a 
# possible ~/matlab/startup.m pointing to an old getfem release
s=`echo "s=getenv('MATLABPATH'); while (length(s)), [a,s]=strtok(s,':'); addpath(a); end; disp(pwd); check_all; pause(5)" | matlab -nodesktop -nosplash 2>&1`;# 2>/dev/null
k=`echo "$s" | grep "All tests succeeded"`;
if test x"$k" = x""; then
  echo "failure: "
  echo "$s" | grep FAIL
  exit 1;
else
  echo "$s" | grep -i "succe";
fi;
