/* -*- c++ -*- (enables emacs c++ mode)                                    */
#ifndef MATLABINT_STD_H__
#define MATLABINT_STD_H__

#include <dal_std.h>
#include <dal_except.h>
#include <bgeot_config.h>

#if ((!defined(GETFEM_MAJOR_VERSION) || !defined(GETFEM_MINOR_VERSION)) || \
     GETFEM_MAJOR_VERSION != 1 || GETFEM_MINOR_VERSION != 6)
#error "you are not using the right version of getfem++ !"
#endif

namespace matlabint
{
  typedef enum { MESH_CLASS_ID, MESHFEM_CLASS_ID, GEOTRANS_CLASS_ID, 
		 FEM_CLASS_ID, INTEG_CLASS_ID, ELTM_CLASS_ID, CVSTRUCT_CLASS_ID,
		 POLY_CLASS_ID, SLICE_CLASS_ID, GETFEMINT_NB_CLASS } getfemint_class_id;
  
  const char *name_of_getfemint_class_id(unsigned cid);

  void attach_gdb();

  #define THROW_INTERNAL_ERROR { DAL_THROW(matlabint::matlabint_error, "matlabint: internal error\n") }

  typedef size_t size_type;
  typedef bgeot::short_type short_type;
  typedef dal::uint32_type id_type;

  #define MATLABINT_CVS_MASK         0x12000000
  #define MATLABINT_PGT_MASK         0x14000000
  #define MATLABINT_PFI_MASK         0x15000000
  #define MATLABINT_PFEM_MASK        0x16000000
  #define MATLABINT_MATELEMTYPE_MASK 0x17000000
  #define MATLABINT_MATELEM_MASK     0x18000000

  class matlabint_error : public std::logic_error {
    //    std::string what_;
  public:
    matlabint_error(const std::string& what_arg) : std::logic_error (what_arg) //what_(what_arg) //
      { }
    //    const char * what() const { return what_.c_str(); }
  };

  class matlabint_bad_arg : public matlabint_error {
  public:
    matlabint_bad_arg(const std::string& what_) : matlabint_error(what_) {}
      //    ~matlabint_bad_arg() throw() {} /* pourquoi g++-3.0 demande de definir cette fonction ? */
  };

  /* no callback for these exceptions */
#define THROW_ERROR(thestr) {                \
    std::stringstream msg;                   \
    msg << thestr << ends;                   \
    throw matlabint_error(msg.str());        \
  }
#define THROW_BADARG(thestr) {               \
    std::stringstream msg;                   \
    msg << thestr << ends;                   \
    throw matlabint_bad_arg(msg.str());      \
  }
  
#define GFI_WARNING(thestr) { infomsg() << "WARNING: " << thestr; }
  std::ostream& infomsg(); // defined in getfem_matlab.C
}
#endif
