/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_pgt.h : geometric transfromations  management.      */
/*     									   */
/*                                                                         */
/* Date : Octobre 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <matlabint_pgt.h>
#include <dal_tree_sorted.h>

namespace matlabint
{
  static dal::dynamic_tree_sorted<bgeot::pgeometric_trans> *pgt_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      pgt_tab = new dal::dynamic_tree_sorted<bgeot::pgeometric_trans>();
    }
  }

  id_type ind_pgt(bgeot::pgeometric_trans p)
  { init_tab(); return pgt_tab->add_norepeat(p); }
  
  bgeot::pgeometric_trans addr_pgt(id_type i)
  { init_tab(); return (*pgt_tab)[i]; }

  bool exists_pgt(id_type i)
  { init_tab(); return pgt_tab->index()[i]; }


}  /* end of namespace matlabint.                                          */
