/* -*- c++ -*- (enables emacs c++ mode) */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_misc.h :                                            */
/*     									   */
/*                                                                         */
/* Date : December  2001.                                                  */
/* Author : J. Pommier, pommier@gmm.insa-tlse.fr                           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#ifndef MATLAB_MISC_H__
#define MATLAB_MISC_H__

#include <matlabint.h>
#include <getfem_export.h>
#include <getfem_mesh_slice.h> // juste pour le struct 'convex_face' ..
namespace matlabint {
  template<class SPMAT> void  smatrix_from_matlab(const gfi_array *m, SPMAT& M);
  template<> void smatrix_from_matlab<gf_sparse_by_row>(const gfi_array *m, gf_sparse_by_row&);
  template<> void smatrix_from_matlab<gf_sparse_by_col>(const gfi_array *m, gf_sparse_by_col&);

  typedef getfem::convex_face convex_face;
  typedef getfem::convex_face_ct convex_face_ct;

  void  smatrix_from_matlab(const gfi_array *m, gf_sparse_by_col &M);
  gfi_array* convert_to_gfi_sparse(const gf_sparse_by_row & smat, double threshold=1e-12);
  gfi_array* convert_to_gfi_sparse(const gf_sparse_by_col & smat, double threshold=1e-12);


  void build_edge_list(const getfem::getfem_mesh &m, bgeot::edge_list &el, mexargs_in &in);

  void build_convex_face_lst(const getfem::getfem_mesh& m, std::vector<convex_face>& l, const mlab_vect *v);
  void interpolate_on_convex_ref(const getfem::mesh_fem *mf, getfem::size_type cv, 
				 const bgeot::vsvector<getfem::base_node> &pt, 
				 const mlab_vect& U,
				 getfem::base_matrix &pt_val);
  void
  eval_on_triangulated_surface(const getfem::getfem_mesh* mesh, int Nrefine,
			       const std::vector<convex_face>& cvf,
			       mexargs_out& out,
			       const getfem::mesh_fem *pmf, const mlab_vect& U);

}
#endif
