/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh.h : mesh management.                           */
/*     									   */
/*                                                                         */
/* Date : August 2002                                                      */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr,J. Pommier           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef MATLABINT_MESH_SLICE_H__
#define MATLABINT_MESH_SLICE_H__

#include <matlabint_std.h>
#include <matlabint_object.h>
#include <getfem_mesh_slice.h>

namespace matlabint
{
  class matlabint_mesh_slice : public getfem_object {
  private:
    getfem::mesh_slice *sl;
    id_type linked_mesh_id_;
  public:
    matlabint_mesh_slice(matlabint_mesh& mi_m, getfem::mesh_slice *sl_) {
      assert(workspace == 0);
      linked_mesh_id_ = mi_m.get_id();
      sl = sl_;
    }
    ~matlabint_mesh_slice() {
      delete sl;
    }
    id_type class_id() const { return SLICE_CLASS_ID; }
    size_type memsize() const { return sl->memsize(); }
    getfem::mesh_slice& mesh_slice() { return *sl; }
    const getfem::mesh_slice& mesh_slice() const { return *sl; }
    id_type linked_mesh_id() const { return linked_mesh_id_;}
  };

  inline bool object_is_mesh_slice(getfem_object *o) {
    return (o->class_id() == SLICE_CLASS_ID);
  }

  inline matlabint_mesh_slice* object_to_mesh_slice(getfem_object *o) {
    if (object_is_mesh_slice(o)) return ((matlabint_mesh_slice*)o);
    else THROW_INTERNAL_ERROR;
  }
}  /* end of namespace matlabint.                                          */

#endif /* MATLABINT_MESH_SLICE_H__                                         */
