/*
 * This is sample code generated by rpcgen.
 * These are only templates and you can use them
 * as a guideline for developing your own functions.
 */
#include <assert.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include "mex.h"
#include "gfm_rpc.h"
#include "gfi_array.h"

static const char*
mxClassID2string(mxClassID id) {
  switch (id) {
  case mxUNKNOWN_CLASS: return "UNKNOWN";
  case mxCELL_CLASS:    return "CELL";
  case mxSTRUCT_CLASS:  return "STRUCT";
  case mxOBJECT_CLASS:  return "OBJECT";
  case mxCHAR_CLASS:    return "CHAR";
  case mxDOUBLE_CLASS:  return "DOUBLE";
  case mxSINGLE_CLASS:  return "SINGLE";
  case mxINT8_CLASS:    return "INT8";
  case mxUINT8_CLASS:   return "UINT8";
  case mxINT16_CLASS:   return "INT16";
  case mxUINT16_CLASS:  return "UINT16";
  case mxINT32_CLASS:   return "INT32";
  case mxUINT32_CLASS:  return "UINT32";
  case mxINT64_CLASS:   return "INT64";
  case mxUINT64_CLASS:  return "UINT64";
  case mxSPARSE_CLASS:  return "SPARSE";
  case mxOPAQUE_CLASS: return "OPAQUE_CLASS";
  default: return "unknown class...";
  }
}

int
mxarray_to_gfi_array(const mxArray *mx, gfi_array *t)
{
  int n = mxGetNumberOfElements(mx);
  assert(t);
  switch (mxGetClassID(mx)) {    
  case mxCELL_CLASS: {
    int i;
    t->storage.type = GFI_CELL;
    t->storage.gfi_storage_u.data_cell.data_cell_len = n;
    t->storage.gfi_storage_u.data_cell.data_cell_val = (gfi_array**)mxCalloc(n, sizeof(gfi_array*));
    for (i = 0; i < n; ++i) {
      if (mxGetCell(mx,i)) {
        t->storage.gfi_storage_u.data_cell.data_cell_val[i] = mxCalloc(1,sizeof(gfi_array));
        if (mxarray_to_gfi_array(mxGetCell(mx,i), t->storage.gfi_storage_u.data_cell.data_cell_val[i]) != 0) return 1;
      } else t->storage.gfi_storage_u.data_cell.data_cell_val[i] = NULL;
    }
  } break;
  case mxCHAR_CLASS: {
    t->storage.type = GFI_CHAR;
    t->storage.gfi_storage_u.data_char.data_char_len = n;    
    t->storage.gfi_storage_u.data_char.data_char_val = mxCalloc(n+1,sizeof(char));
    mxGetString(mx,t->storage.gfi_storage_u.data_char.data_char_val,n+1);
  } break;
  case mxINT32_CLASS: {
    t->storage.type = GFI_INT32;
    t->storage.gfi_storage_u.data_int32.data_int32_len = n;
    t->storage.gfi_storage_u.data_int32.data_int32_val = mxGetData(mx);
  } break;
  case mxUINT32_CLASS: {
    t->storage.type = GFI_UINT32;
    t->storage.gfi_storage_u.data_uint32.data_uint32_len = n;
    t->storage.gfi_storage_u.data_uint32.data_uint32_val = mxGetData(mx);
  } break;
  case mxSPARSE_CLASS: /* for older (i.e. 6.1) matlab versions... */
  case mxDOUBLE_CLASS: {
    if (!mxIsSparse(mx)) {
      t->storage.type = GFI_DOUBLE;
      t->storage.gfi_storage_u.data_double.data_double_len = n;
      t->storage.gfi_storage_u.data_double.data_double_val = mxGetData(mx);
    } else {
      t->storage.type = GFI_SPARSE;
      t->storage.gfi_storage_u.sp.ir.ir_len = mxGetNzmax(mx); t->storage.gfi_storage_u.sp.ir.ir_val = mxGetIr(mx);
      t->storage.gfi_storage_u.sp.jc.jc_len = mxGetN(mx)+1; t->storage.gfi_storage_u.sp.jc.jc_val = mxGetJc(mx);
      t->storage.gfi_storage_u.sp.pr.pr_len = mxGetNzmax(mx); t->storage.gfi_storage_u.sp.pr.pr_val = mxGetPr(mx);
    }
  } break;
  case mxOBJECT_CLASS:
  case mxSTRUCT_CLASS: {
    mxArray *fid = mxGetField(mx, 0, "id");
    mxArray *fcid = mxGetField(mx, 0, "cid");
    if (fid && mxGetClassID(fid) == mxUINT32_CLASS &&
        fcid && mxGetClassID(fcid) == mxUINT32_CLASS) {
      int n = mxGetNumberOfElements(fid),i;
      assert(n == mxGetNumberOfElements(fcid));
      if (mxGetNumberOfElements(fid) >= 1) {
        t->storage.type = GFI_OBJID;
        t->storage.gfi_storage_u.objid.objid_len = mxGetNumberOfElements(fid);
        t->storage.gfi_storage_u.objid.objid_val = mxCalloc(n, sizeof(gfi_object_id));
        for (i=0; i < n; ++i) {
          t->storage.gfi_storage_u.objid.objid_val[i].id = ((int*)mxGetData(fid))[i];
          t->storage.gfi_storage_u.objid.objid_val[i].cid = ((int*)mxGetData(fcid))[i];
        }
      } else {
        mexPrintf("empty arrays of getfem object ids not handled"); return 1;
      }
    } else { 
      mexPrintf("matlab structures (except getfem object ids) not handled"); return 1; 
    }
  } break;
  default: {
    mexPrintf("unhandled class type : %s\n", mxClassID2string(mxGetClassID(mx)));
    return 1;
  } break;    
  }
  t->dim.dim_len = mxGetNumberOfDimensions(mx);
  t->dim.dim_val = (u_int*)mxGetDimensions(mx);
  return 0;
}

mxArray*
gfi_array_to_mxarray(gfi_array *t) {
  mxArray *m;
  assert(t);
  switch (t->storage.type) {
  case GFI_UINT32: 
  case GFI_INT32: {
    m = mxCreateNumericArray(t->dim.dim_len, (const int*)t->dim.dim_val, (t->storage.type == GFI_UINT32) ? mxUINT32_CLASS:mxINT32_CLASS, mxREAL);
    memcpy(mxGetData(m), t->storage.gfi_storage_u.data_int32.data_int32_val, sizeof(int)*t->storage.gfi_storage_u.data_int32.data_int32_len);
  } break;
  case GFI_DOUBLE: {
    m = mxCreateNumericArray(t->dim.dim_len, (const int*)t->dim.dim_val, mxDOUBLE_CLASS, mxREAL);
    memcpy(mxGetData(m), t->storage.gfi_storage_u.data_double.data_double_val, sizeof(double)*t->storage.gfi_storage_u.data_double.data_double_len);
  } break;
  case GFI_CHAR: {
    char *s = calloc(t->storage.gfi_storage_u.data_char.data_char_len+1,1); 
    strncpy(s,t->storage.gfi_storage_u.data_char.data_char_val,t->storage.gfi_storage_u.data_char.data_char_len);
    m = mxCreateString(s); free(s);
  } break;
  case GFI_CELL: {
    unsigned i;
    m = mxCreateCellArray(t->dim.dim_len, (const int*)t->dim.dim_val);
    for (i=0; i < t->storage.gfi_storage_u.data_cell.data_cell_len; ++i)
      mxSetCell(m,i,gfi_array_to_mxarray(t->storage.gfi_storage_u.data_cell.data_cell_val[i]));
  } break;
  case GFI_OBJID: {
    unsigned i,j=1;
    static const char *fields[] = {"id","cid"};
    mxArray *mxid, *mxcid;
    m = mxCreateStructArray(1, (const int*)&t->storage.gfi_storage_u.objid.objid_len, 2, fields);
    for (i=0; i < t->storage.gfi_storage_u.objid.objid_len; ++i) {
      mxid = mxCreateNumericArray(1, (const int*)&j, mxUINT32_CLASS, mxREAL);
      *(int*)mxGetData(mxid) = t->storage.gfi_storage_u.objid.objid_val[i].id;
      mxSetField(m,i,fields[0], mxid);
      mxcid = mxCreateNumericArray(1, (const int*)&j, mxUINT32_CLASS, mxREAL);
      *(int*)mxGetData(mxcid) = t->storage.gfi_storage_u.objid.objid_val[i].cid;
      mxSetField(m,i,fields[1], mxcid);
    }
  } break;
  case GFI_SPARSE: {
    m = mxCreateSparse(t->dim.dim_val[0], t->dim.dim_val[1], t->storage.gfi_storage_u.sp.pr.pr_len,mxREAL);
    memcpy(mxGetIr(m), t->storage.gfi_storage_u.sp.ir.ir_val, t->storage.gfi_storage_u.sp.ir.ir_len * sizeof(int));
    memcpy(mxGetJc(m), t->storage.gfi_storage_u.sp.jc.jc_val, t->storage.gfi_storage_u.sp.jc.jc_len * sizeof(int));
    memcpy(mxGetPr(m), t->storage.gfi_storage_u.sp.pr.pr_val, t->storage.gfi_storage_u.sp.pr.pr_len * sizeof(double));
  } break;
  default:  {
    assert(0);
  } break;
  }
  return m;
}


gfi_array_list *
build_gfi_array_list(int nrhs, const mxArray *prhs[]) {
  gfi_array_list *l;
  int i;
  l = mxCalloc(1,sizeof(gfi_array_list));
  l->arg.arg_len = nrhs;
  l->arg.arg_val = mxCalloc(nrhs, sizeof(gfi_array));
  for (i=0; i < nrhs; ++i) {
    mxarray_to_gfi_array(prhs[i], &l->arg.arg_val[i]);
  }
  return l;
}



pid_t local_pid = 0;
char *remote_hostname = NULL;
int remote_port = -1;
int local_socket = -1;
int remote_socket = -1;



#ifndef PATH_MAX
#define PATH_MAX 1024 
#endif

void install_custom_sigint();
void remove_custom_sigint();
#ifndef INVALID_SOCKET
#define INVALID_SOCKET -1
#endif

void
gfmrpc_1(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  CLIENT *clnt;
  void  *test;
  gfi_output *out;
  gfi_array_list *in;
  char *function = NULL;
  /*static char saved_current_dir[PATH_MAX] = "";*/
  char current_dir[PATH_MAX];
  struct timeval tv;

  if (nrhs == 0 || !mxIsChar(prhs[0])) {
    mexErrMsgTxt("missing function name");
  }
  function = calloc(mxGetNumberOfElements(prhs[0])+1,1);
  if (mxGetString(prhs[0], function, mxGetNumberOfElements(prhs[0])+1))
    mexErrMsgTxt("mxGetString failure");
#ifndef	DEBUG
  /*clnt = clnt_create (host, GFMRPC, GFMRPC_VERS_1, "tcp");*/
  if (remote_hostname) {
    if (remote_port == -1) {
      clnt = clnt_create (remote_hostname, GFMRPC, GFMRPC_VERS_1, "tcp");
    } else {
      struct sockaddr_in addr;
      struct hostent *h = NULL;
      if ((h = gethostbyname(remote_hostname)) == NULL) {
        mexPrintf("can't get addr for %s\n",remote_hostname); mexErrMsgTxt("");
        return;
      }
      memset(&addr, 0, sizeof (addr));
      addr.sin_family = h->h_addrtype;
      addr.sin_port = htons(remote_port);
      bcopy(h->h_addr, (char*)&addr.sin_addr, h->h_length);
        /*      addr.sin_addr.s_addr = ((struct in_addr*)(h->h_addr))->s_addr;*/
      mexPrintf("creating client handle for %s:%d\n", remote_hostname,remote_port);
      if (remote_socket != -1) { close(remote_socket); remote_socket = RPC_ANYSOCK; }
      clnt=clnttcp_create (&addr, GFMRPC, GFMRPC_VERS_1, &remote_socket, 0, 0); 
    }
  } else {
    /*clnt = clnt_create (local_sockname, GFMRPC, GFMRPC_VERS_1, "unix");*/
    struct sockaddr_in sin;

    memset (&sin, 0, sizeof (sin));
    sin.sin_port = 1; /* do not call portmap (it would be stupid to require the portmap service  for this kind of connection!) */    
    clnt=clnttcp_create (&sin, GFMRPC, GFMRPC_VERS_1, &local_socket, 0, 0);
  }
  if (clnt == NULL) {
    clnt_pcreateerror (remote_hostname == NULL ? "localhost" : remote_hostname);
    return;
  } else {
    struct timeval tv;
    tv.tv_sec = 25;
    tv.tv_usec = 0;
    clnt_control(clnt, CLSET_TIMEOUT, (char*)&tv);
  }
#endif	/* DEBUG */

  test = gfmrpc_null_1(clnt);
  if (test == (void *) NULL) {
    mexPrintf("[oups] could not connect to getfem_matlab server...");
    clnt_perror(clnt, ""); goto cleanup;
  }
  getcwd(current_dir, PATH_MAX); current_dir[PATH_MAX-1]=0;
  /*  if (strcmp(current_dir, saved_current_dir)) {
      strcpy(saved_current_dir, current_dir);*/
    test = gfmrpc_chdir_1(current_dir, clnt);
    if (test == (void *) NULL) {
      mexPrintf("[get cwd] could not connect to getfem_matlab server...");
      clnt_perror (clnt, ""); goto cleanup;
    }
    /* }*/
  tv.tv_sec = 1000000; tv.tv_usec = 0;
  clnt_control(clnt, CLSET_TIMEOUT, (char*)&tv);
  in = build_gfi_array_list(nrhs-1, prhs+1);

  install_custom_sigint();
  out = gfmrpc_call_1(function, *in, nlhs, clnt);
  remove_custom_sigint();
  if (out == NULL) {
    mexPrintf("[getfem_server call] something went wrong...");
    clnt_perror (clnt, "");
  } else {
    if (out->infomsg && strlen(out->infomsg)) { mexPrintf("message from [gf_%s]:\n%s\n", function, out->infomsg); }

    if (out->status == GFI_STATUS_OK) {
      gfi_array_list *outl = &out->gfi_output_u.output;
      unsigned i;
      if (nlhs == 0 && outl->arg.arg_len > 0) { /* not very nice */
	mxArray *mx = gfi_array_to_mxarray(&outl->arg.arg_val[0]);
#if MATLAB_RELEASE == 12
	mexPutArray(mx, "caller"); mxSetName(mx,"ans");
#else
	mexPutVariable("caller", "ans", mx);
#endif
      }
      for (i=0; i < outl->arg.arg_len; ++i) {
        plhs[i] = gfi_array_to_mxarray(&outl->arg.arg_val[i]);              
        gfi_array_destroy(&outl->arg.arg_val[i]);
      }
    } else {
      mexErrMsgTxt(out->gfi_output_u.errmsg);
    }
  }
 cleanup:
#ifndef	DEBUG
  clnt_destroy (clnt);
#endif	 /* DEBUG */
}

int mxstringmatch(const mxArray *mx, const char *s) {
  if (mxIsChar(mx)) {
    char tmp[1000];
    mxGetString(mx,tmp,1000);
    return (strcasecmp(tmp,s) == 0);
  } else return 0;
}

char *mxallocstring(const mxArray *mx) {
  int n;
  char *s;
  if (!mxIsChar(mx)) { mexErrMsgTxt("string expected"); }
  n = mxGetNumberOfElements(mx);
  s = calloc(n+1,1);
  mxGetString(mx,s,n+1);
  return s;
}

void kill_local_session() {
  if (local_pid) {
    int status;
    mexPrintf("killing getfem_matlab (%d)..\n", local_pid);
    kill(local_pid, SIGINT);
    waitpid(local_pid, &status, 0);
    local_pid = 0;
  }
}

void start_local_session() {
  int sock[2];
  if (local_pid == 0) {
    if (socketpair(AF_UNIX, SOCK_STREAM, 0, sock) < 0) {
      mexErrMsgTxt("unable to create a socket for the server..");
    }
    mexPrintf("starting local getfem_server...\n");
    switch ((local_pid=fork())) {
    case -1: mexErrMsgTxt("can't fork !"); return;
    case 0: /* child */
      {
        close(sock[0]);
        dup2(sock[1],4); /* avoid stdin, stdout and stderr */
        setsid(); /* the server won't be killed by Ctrl-C pressed in matlab */
        execlp("getfem_server", "getfem_server", "-slave", NULL);
        fprintf(stderr, "execlp failure .. : %s\n", strerror(errno));
        exit(1); /* in case the exec failed */
      } break;
    default:
      {
        close(sock[1]);
	local_socket = sock[0];
      } break;
    }
  }
}


struct sigaction old_sigint;
int sigint_hit = 0;

void sigint(int);

void install_custom_sigint() {
  struct sigaction new_sigint;
  new_sigint.sa_handler = sigint;
  sigemptyset(&new_sigint.sa_mask);
  new_sigint.sa_flags = 0;

  sigaction (SIGINT, NULL, &old_sigint);
  if (old_sigint.sa_handler != SIG_IGN)
    sigaction(SIGINT, &new_sigint, NULL);
  sigint_hit = 0;
}

void remove_custom_sigint() {
  struct sigaction act;
  sigaction (SIGINT, NULL, &act);
  if (act.sa_handler == sigint) {
    sigaction(SIGINT, &old_sigint, NULL);
  }
  if (sigint_hit) { 
    fprintf(stderr, "ready, raising SIGINT now\n");
    raise(SIGINT); sigint_hit = 0; 
  }
}

void sigint(int sig) {
  fprintf(stderr, "*** CTRL-C hit during execution of a getfem_matlab function...\n" \
	  "You will gain control as soon as the current operation is finished ***\n" \
	  "If you want to abort immediatly the current operation, hit CTRL-C again\n" \
	  "(in that case, the getfem_matlab server will have to be restarted)");
  remove_custom_sigint();
  sigint_hit++;
}

/* returns 0 if the child has not exited, or its pid */
int check_local_session() {
  int status;
  if (local_pid) {
    int res = waitpid(local_pid, &status, WNOHANG);
    /*fprintf(stderr,"wait(pid=%d)=%d ; status=%d [%s]\n", local_pid, res, status, strerror(errno));*/
    return (res == 0 ? local_pid : 0);
  } else return 0;
}

void exitfcn(void) {
  kill_local_session();
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  static int once=0;
  if (once==0) { ++once; mexAtExit(exitfcn); }

  if (nrhs > 1 && mxstringmatch(prhs[0],"workspace")) {
    if (mxstringmatch(prhs[1], "connect") && nrhs >= 3) {
      kill_local_session();
      remote_hostname = mxallocstring(prhs[2]);
      if (nrhs == 4) remote_port = (int)(*mxGetPr(prhs[3]));
      mexPrintf("connection to %s", remote_hostname); 
      if (remote_port != -1) mexPrintf(", port %d\n", remote_port);
      else mexPrintf(", using portmap\n");
      return;
    }

  }
  local_pid = check_local_session();
  if (local_pid == 0 && remote_hostname == 0)
    start_local_session();
  if (local_pid != check_local_session()) {
    mexErrMsgTxt("could not launch the server, check that it is in the PATH");
    local_pid = 0;
  }

  gfmrpc_1(nlhs, plhs, nrhs, prhs);
}
