#ifndef GFI_ARRAY
#define GFI_ARRAY

#include <sys/types.h>
#ifdef USE_RPC
# include <rpc/types.h>
#else
  typedef unsigned int u_int;
# define u_int unsigned int
#endif
#ifdef __cplusplus
extern "C" {
#endif

  /* extrait du gfm_rpc.h genere par rpcgen */
enum gfi_type_id {
	GFI_INT32 = 0,
	GFI_UINT32 = 1,
	GFI_DOUBLE = 2,
	GFI_CHAR = 3,
	GFI_CELL = 4,
	GFI_OBJID = 5,
	GFI_SPARSE = 6
};
typedef enum gfi_type_id gfi_type_id;

struct gfi_object_id {
	int id;
	int cid;
};
typedef struct gfi_object_id gfi_object_id;

struct gfi_sparse {
	struct {
		u_int ir_len;
		int *ir_val;
	} ir;
	struct {
		u_int jc_len;
		int *jc_val;
	} jc;
	struct {
		u_int pr_len;
		double *pr_val;
	} pr;
};
typedef struct gfi_sparse gfi_sparse;

typedef struct gfi_array *pgfi_array;

struct gfi_storage {
	gfi_type_id type;
	union {
		struct {
			u_int data_int32_len;
			int *data_int32_val;
		} data_int32;
		struct {
			u_int data_uint32_len;
			u_int *data_uint32_val;
		} data_uint32;
		struct {
			u_int data_double_len;
			double *data_double_val;
		} data_double;
		struct {
			u_int data_char_len;
			char *data_char_val;
		} data_char;
		struct {
			u_int data_cell_len;
			pgfi_array *data_cell_val;
		} data_cell;
		struct {
			u_int objid_len;
			struct gfi_object_id *objid_val;
		} objid;
		struct gfi_sparse sp;
	} gfi_storage_u;
};
typedef struct gfi_storage gfi_storage;

struct gfi_array {
	struct {
		u_int dim_len;
		u_int *dim_val;
	} dim;
	gfi_storage storage;
};
typedef struct gfi_array gfi_array;

struct gfi_array_list {
	struct {
		u_int arg_len;
		gfi_array *arg_val;
	} arg;
};
typedef struct gfi_array_list gfi_array_list;

enum gfi_status {
	GFI_STATUS_OK = 0,
	GFI_STATUS_ERROR = 1
};
typedef enum gfi_status gfi_status;

struct gfi_output {
	gfi_status status;
	union {
		gfi_array_list output;
		char *errmsg;
	} gfi_output_u;
  char *infomsg;
};
typedef struct gfi_output gfi_output;



gfi_array*
gfi_array_create(int ndim, int *dims, gfi_type_id type);
gfi_array*
gfi_array_create_1(int M, gfi_type_id type);
gfi_array*
gfi_array_create_2(int M, int N, gfi_type_id type);
gfi_array*
gfi_array_from_string(const char *s);
gfi_array*
gfi_create_sparse(int m, int n, int nzmax);
  /*gfi_array*
    gfi_create_objid(int nid, unsigned *ids, unsigned cid);*/
void 
gfi_array_destroy(gfi_array *t);
int
gfi_array_get_ndim(const gfi_array*t);
const int*
gfi_array_get_dim(const gfi_array*t);
unsigned 
gfi_array_nb_of_elements(const gfi_array *t);
unsigned int*
gfi_sparse_get_ir(const gfi_array *t);
unsigned int*
gfi_sparse_get_jc(const gfi_array *t);
double*
gfi_sparse_get_pr(const gfi_array *t);
char*
gfi_char_get_data(const gfi_array* t);
int*
gfi_int32_get_data(const gfi_array *t);
int*
gfi_uint32_get_data(const gfi_array *t);
double*
gfi_double_get_data(const gfi_array* t);
gfi_array**
gfi_cell_get_data(const gfi_array *t);
gfi_object_id*
gfi_objid_get_data(const gfi_array *t);
gfi_type_id
gfi_array_get_class(const gfi_array *t);
const char*
gfi_array_get_class_name(const gfi_array *t);
const char *
gfi_type_id_name(gfi_type_id id);
void gfi_array_print(gfi_array *t);

#ifdef __cplusplus
}
#endif

#endif
