#include <matlabint.h>
#include <matlabint_misc.h>
#include <gmm_inoutput.h>

using namespace matlabint;
namespace matlabint {
  /*  struct solver {
    gmm::iteration iter;
    solver(double res, int maxiter) : iter(res,0,maxiter) {}
    virtual void do_solve() = 0;
    virtual ~solver() {};
  };
  
  struct solve_cg : public solver {
    
  };
  */
}

void do_solve(matlabint::mexargs_in& in, matlabint::mexargs_out& out) {
  gf_sparse_matlab_const_ref A;  in.pop().to_sparse(A);
  mlab_vect b = in.pop().to_scalar_vector(gmm::mat_ncols(A));
  mlab_vect x = out.pop().create_vector(gmm::mat_nrows(A));
  std::string sv = in.pop().to_string();
  gmm::iteration iter(1e-16);
  cerr << "maxiter=" << iter.get_maxiter() << endl;
  if (cmd_strmatch(sv, "cg")) {
    if (in.remaining()) {
      std::string sprecond = in.pop().to_string();
      if (cmd_strmatch(sprecond,"cholinc")) {
	int rempl = 10;
	double threshold = 1e-6;
	if (in.remaining()) rempl = in.pop().to_integer(0,1000000);
	if (in.remaining()) threshold = in.pop().to_scalar(0.0,1.0);
	gmm::choleskyt_precond<gf_sparse_matlab_const_ref> cholp(A, rempl, threshold);
	gmm::cg(A, x, b, cholp,  iter);
      } else if (cmd_strmatch(sprecond,"cholinc0")) {
	gmm::cholesky_precond<gf_sparse_matlab_const_ref> cholp(A);
	gmm::cg(A, x, b, cholp,  iter);
      } else THROW_BADARG("wrong preconditionner : " << sprecond);
    } else {
      gmm::cg(A, x, b, gmm::identity_matrix(), iter);
    }
  } else if (cmd_strmatch(sv, "bicgstab")) {
    gmm::bicgstab(A, x, b, gmm::identity_matrix(), iter);
  } else if (cmd_strmatch(sv, "gmres")) {
    int restart = in.pop().to_integer(1,1000000);
    gmm::gmres(A, x, b, gmm::identity_matrix(), restart, iter);
  } else if (cmd_strmatch(sv, "lu")) {
    gmm::dense_matrix<double> Af(gmm::mat_nrows(A),gmm::mat_ncols(A)); gmm::copy(A,Af);
    cerr << "debut lu" << endl;
    gmm::lu_solve(Af, x, b);
    cerr << "fin lu" << endl;
  } else THROW_BADARG("unknown sparse solver name : " << sv);
  if (!iter.converged()) cerr << "warning: " << sv << " did not converge\n";    
  cerr << "nb_iter: " << iter.get_iteration() << endl;
}

/*MLABCOM
  FUNCTION gf_util(operation, poly [,args])

  Performs various operations

  * gf_util('save matrix', string FMT, string FILENAME, spmat A);

  Exports a sparse matrix into the file named FILENAME, using
  Harwell-Boeing (FMT='hb') or Matrix-Market (FMT='mm') formatting.

  * A = gf_util('load matrix', string FMT, string FILENAME);

  Imports a sparse matrix from a file.

MLABCOM*/

void gf_util(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG("Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();

  if (check_cmd(cmd, "save matrix", in, out, 3, 3, 0, 0)) {
    std::string fmt = in.pop().to_string();
    std::string fname = in.pop().to_string();
    gf_sparse_matlab_const_ref H;  in.pop().to_sparse(H);
    gmm::csc_matrix<double> cscH; gmm::copy(H,cscH);
    if (cmd_strmatch(fmt, "hb") || cmd_strmatch(fmt, "harwell-boeing")) {
      gmm::Harwell_Boeing_save(fname.c_str(), cscH);
    } else if (cmd_strmatch(fmt, "mm") || cmd_strmatch(fmt, "matrix-market")) {
      gmm::MatrixMarket_save(fname.c_str(), cscH);
    } else THROW_BADARG("unknown sparse matrix file-format : " << fmt);
  } else if (check_cmd(cmd, "load matrix", in, out, 2, 2, 1, 1)) {
    std::string fmt = in.pop().to_string();
    std::string fname = in.pop().to_string();
    if (cmd_strmatch(fmt, "hb") || cmd_strmatch(fmt, "harwell-boeing")) {
      gmm::csc_matrix<double> cscH;
      Harwell_Boeing_load(fname.c_str(), cscH);
      gf_sparse_by_col H(gmm::mat_nrows(cscH), gmm::mat_ncols(cscH));
      gmm::copy(cscH,H);
      out.pop().from_sparse(H);
    } else if (cmd_strmatch(fmt, "mm") || cmd_strmatch(fmt, "matrix-market")) {
      gf_sparse_by_col H;
      gmm::MatrixMarket_load(fname.c_str(), H);
      out.pop().from_sparse(H);
    } else THROW_BADARG("unknown sparse matrix file-format : " << fmt);
  } else if (check_cmd(cmd, "solve", in, out, 3, -1, 0, 1)) {
    do_solve(in,out);
  } else bad_cmd(cmd);
}

