#include <matlabint_misc.h>
#include <matlabint_mesh_fem.h>
#include <matlabint_pfi.h>
#include <matlabint_pfem.h>

/*
  $Id: gf_mesh_fem_get.C,v 1.4 2003/10/05 16:03:40 pommier Exp $

  ChangeLog:
  $Log: gf_mesh_fem_get.C,v $
  Revision 1.4  2003/10/05 16:03:40  pommier
  change all bit_vector loops to bv_visitor

  Revision 1.3  2003/07/31 13:23:48  renard
  ajout du numero de convexe dans les paramtres de gen_compute

  Revision 1.2  2003/07/25 09:04:30  pommier
  *** empty log message ***

  Revision 1.1  2003/05/22 13:18:03  pommier
  regroupement de tous les fichiers dans ./src , et mise en place des RPC

  Revision 1.28  2003/05/05 17:08:51  pommier
  changement de dal::bit_vector::add(i,j) en dal::bit_vector::add(i,nb)

  Revision 1.27  2003/03/14 15:14:46  pommier
  ajout acx_getfem

  Revision 1.26  2003/03/11 15:00:30  pommier
  creation du changelog

  Revision 1.25  2003/02/27 16:34:17  pommier
  improve friendlyness with gcc2.95

  Revision 1.24  2003/02/18 09:36:28  pommier
  update doc

 */


using namespace matlabint;

typedef enum {IS_LAGRANGE, IS_EQUIVALENT, IS_POLYNOMIAL} test_what;
static void
test_fems(test_what what, const getfem::mesh_fem *mf, mexargs_in& in, mexargs_out& out)
{
  dal::bit_vector cvlst;
  bool return_bool = false;
  dal::bit_vector islst;
  if (in.remaining()) cvlst = in.pop().to_bit_vector(&mf->linked_mesh().convex_index());
  else { cvlst = mf->linked_mesh().convex_index(); return_bool = true; }
  for (dal::bv_visitor cv(cvlst); !cv.finished(); ++cv) {
    bool it_is = false;
    if (!mf->linked_mesh().convex_index()[cv]) THROW_ERROR( "convex " << cv+1 << " does not exist");
    check_cv_fem(*mf, cv);
    switch (what) { /* hope the compiler will optimize that */
    case IS_LAGRANGE:   it_is = mf->fem_of_element(cv)->is_lagrange(); break;
    case IS_EQUIVALENT: it_is = mf->fem_of_element(cv)->is_equivalent(); break;
    case IS_POLYNOMIAL: it_is = mf->fem_of_element(cv)->is_polynomial(); break;
    }
    if (it_is) {
      islst.add(cv);
    }
  }
  if (return_bool) {
    out.pop().from_integer(islst.card() == mf->linked_mesh().convex_index().card() ? 1 : 0);
  } else {
    out.pop().from_bit_vector(islst);
  }
}

static void
get_fem_or_integ_of_convexes(const getfem::mesh_fem& mf, mexargs_in& in, mexargs_out& out, id_type class_id)
{  
  dal::bit_vector cvlst;
  if (in.remaining()) cvlst = in.pop().to_bit_vector(&mf.linked_mesh().convex_index());
  else { cvlst = mf.linked_mesh().convex_index(); }
  std::vector<id_type> ids; ids.reserve(cvlst.card());
  for (dal::bv_visitor cv(cvlst); !cv.finished(); ++cv) {
    if (mf.convex_index().is_in(cv))
      if (class_id == FEM_CLASS_ID)
	ids.push_back(ind_pfem(mf.fem_of_element(cv)));
      else ids.push_back(ind_pfi(mf.int_method_of_element(cv)));
    else ids.push_back(id_type(-1));
  }
  out.return_packed_obj_ids(ids, class_id);
}

static dal::bit_vector
get_cv_dof_list(getfem::mesh_fem *mf, mexargs_in& in) {
  std::vector<convex_face> cvf;
  dal::bit_vector dof; 
  if (in.remaining()) {
    mlab_vect v = in.pop().to_int_vector(-1, -1);
    build_convex_face_lst(mf->linked_mesh(), cvf, &v);
  } else build_convex_face_lst(mf->linked_mesh(), cvf, 0);
  for (size_type j = 0; j < cvf.size(); ++j) { 
    size_type cv = cvf[j].cv;
    size_type  f = cvf[j].f;
    if (!mf->convex_index().is_in(cv))
      THROW_ERROR( "convex " << cv+1 << " has no FEM!"); 
    if (f != dim_type(-1)) {
      getfem::ind_ref_mesh_dof_ind_ct c = mf->ind_dof_of_face_of_element(cv,f); 
    //std::for_each(c.begin(), c.end(), std::bind1st(std::mem_fun(&dal::bit_vector::add),&dof)); // not SGI STL compliant !?
      for (getfem::ind_ref_mesh_dof_ind_ct::const_iterator it = c.begin(); it != c.end(); it++) 
	dof.add(*it); 
    } else {
      getfem::ref_mesh_dof_ind_ct cvdof = mf->ind_dof_of_element(cv); 
      for (getfem::ref_mesh_dof_ind_ct::const_iterator it = cvdof.begin(); it != cvdof.end(); it++) 
	dof.add(*it);
    }
  } 
  return dof;
}

static void
non_conformal_dof(getfem::mesh_fem &mf, mexargs_in &in, mexargs_out &out)
{
  dal::bit_vector cvlst;
  getfem::getfem_mesh &m = mf.linked_mesh();

  bgeot::vsvector<bgeot::short_type> dcnt(mf.nb_dof());

  if (in.remaining()) cvlst = in.pop().to_bit_vector(&m.convex_index());
  else cvlst = m.convex_index();
  
  for (dal::bv_visitor ic(cvlst); !ic.finished(); ++ic) {
    check_cv_fem(mf, ic);
    for (size_type f = 0; f < m.structure_of_convex(ic)->nb_faces(); f++) {
      bgeot::short_type q;
      if (bgeot::neighbour_of_convex(m, ic, f).empty()) {
	q = 2;
      } else {
	q = 1;
      }      
      for (size_type i = 0; i < mf.ind_dof_of_face_of_element(ic,f).size(); ++i) {
	dcnt[mf.ind_dof_of_face_of_element(ic,f)[i]]+=q;
      }
    }
  }
  mlab_vect w = out.pop().create_vector(1,std::count_if(dcnt.begin(), dcnt.end(), 
                                          std::bind2nd(std::equal_to<bgeot::short_type>(),1)));
  size_type i,j=0;
  /*
  std::copy_if(dcnt.begin(), dcnt.end(), 
	       std::bind2nd(std::less_equal<bgeot::short_type>(),1)));
  */
  for (i=0; i < dcnt.size(); ++i) {
    if (dcnt[i] == 1) w[j++] = i+1;
  }
}


/*MLABCOM
  FUNCTION [x] = gf_mesh_fem_get(meshfem MF, operation [, args])

  General function for inquiring mesh_fem objects

  * I = gf_mesh_fem_get(MF, 'nbdof')
  Returns the number of degree of freedom of the mesh_fem mf.

  * I = gf_mesh_fem_get(MF, 'dof from cv', CVLST)
  Returns the dof of the convexes listed in CVLST. WARNING: the
  Degree of Freedom might be returned in ANY order, do not use this
  function in your assembly routines. Use 'ordered dof from cv' instead.
  One can also get the list of dof on a set on convex faces, by indicating
  on the second row of CVLST the faces numbers (with respect to the convex
  number on the first row).

  * I = gf_mesh_fem_get(MF, 'ordered dof from cv', CV)
  Returns the dof of the convex CV, in the same order as the one used 
  in elementary matrices.

  * I = gf_mesh_fem_get(MF, 'non conformal dof' [,CVLST])
  Returns the dof located on the border of a convex and which belong
  to only one convex, except the ones which are located on the border
  of the mesh.  For example, if the convex 'a' and 'b' share a common
  face, 'a' has a P1 FEM, and 'b' has a P2 FEM, then the dof on the
  middle of the face will be returned by this function (this can be
  useful when searching the interfaces between classical fems and
  hierachical fem).

  * I = gf_mesh_fem_get(MF, 'qdim')
  Returns the dimension Q of the field interpolated by the mesh_fem.
  By default, Q=1 (scalar field). This has an impact on the DOF numbering.

  * [FEMLST, CV2F] = gf_mesh_fem_get(MF, 'fem', CVLST)
  Returns a list of FEM handles. FEMLST is an array of all FEM objects found in
  the convexes given in CVLST. If CV2F was supplied as an output argument, it
  contains, for each convex listed in CVLST, the index of its correspounding
  FEM in FEMLST.

  Example:
     cvid=gf_mesh_get(mf,'cvid');
     [f,c2f]=gf_mesh_fem_get(mf, 'fem');
     for i=1:size(f), sf{i}=gf_fem_get('char',f(i)); end;
     for i=1:size(c2f),
       disp(sprintf('the fem of convex %d is %s',...
            cvid(i),sf{i}));
     end;

  * [INTEG, CV2I] = gf_mesh_fem_get(MF, 'integ', CVLIST)
  Returns the integration method for the selected convexes (similar to
  the 'fem' command).

  * I = gf_mesh_fem_get(MF, {'is_lagrangian' |
                             'is_equivalent' |
                             'is_polynomial'} [,CVLST])
  This function tests the properties of the FEM of the convexes listes
  in CVLIST.  if CVLST is omitted, it returns 1 if all convexes
  in the mesh are lagrangian (resp. equivalents, resp. polynomials),
  or 0. If CVLST is present, it returns the convex numbers (from the
  ones in CVLST) which are lagrangian (resp. etc..)

  * M = gf_mesh_fem_get(MF, 'eltm', eltm MET, int CV)
  Returns the elementary matrix evaluated on the convex CV for the
  elementary matrix type MET.
  !!WARNING!! Be sure that the fem used for the construction of MET is compatible
  with the fem assigned to element CV ! This is not checked by the function !

  * M = gf_mesh_fem_get(MF, 'eltm on face', eltm MET, int CV, int F)
  Returns the elementary matrix evaluated on the face F of convex CV, for the
  elementary matrix type MET.

  * BLST = gf_mesh_fem_get(MF, 'boundaries')
  Returns the list of valid boundaries

  * CVFLST = gf_mesh_fem_get(MF, 'boundary', bnum)
  Returns the list of faces on the boundary 'bnum'. On output, the first row of
  I contains the convex numbers, and the second row contains the face numbers.

  * [DOF_XY] = gf_mesh_fem_get(MF, 'dof nodes'[, DOFLST])
  Returns the list of interpolation points for the specified dof IDs in DOFLST
  (if DOFLST is omitted, all dof are considered).

  * gf_mesh_fem_get(MF, 'save', filename [,with mesh])
  Saves a mesh_fem in a text file (and optionnaly its linked mesh object)

  * S=gf_mesh_fem_get(M, 'char' [,'with mesh'])
  Output a string description of the mesh_fem M. By default, it does not contain the
  description of the linked mesh object.

  * M=gf_mesh_fem_get(MF, 'linked mesh')
  Returns a reference to the mesh object linked to MF.

  * U=gf_mesh_fem_get(MF, 'eval', expr [,DOFLST])

  Calls gf_mesh_fem_get_eval. This function interpolates an expression on a
  mesh_fem (for all dof except if DOFLST is specified). The expression can be a
  numeric constant, or a cell array containing numeric constants, string
  expressions or function handles. For example:
    U1=gf_mesh_fem_get(mf,'eval',1)
    U2=gf_mesh_fem_get(mf,'eval',[1;0]) % output has two rows
    U3=gf_mesh_fem_get(mf,'eval',[1 0]) % output has one row, only valid if qdim(mf)==2
    U4=gf_mesh_fem_get(mf,'eval',{'x';'y.*z';4;@myfunctionofxyz})

  * ms=gf_mesh_fem_get(M, 'memsize')
  Returns the amount of memory (in bytes) used by the mesh_fem object (the linked
  mesh object is not counted).

  $Id: gf_mesh_fem_get.C,v 1.4 2003/10/05 16:03:40 pommier Exp $
MLABCOM*/
/*MLABEXT
  if (nargin>=2 & strcmpi(varargin{2},'eval')),
    [varargout{1:nargout}]=gf_mesh_fem_get_eval(varargin{[1 3:nargin]}); return;
  end;
  MLABEXT*/


void gf_mesh_fem_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 2) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  matlabint_mesh_fem *mi_mf = in.pop().to_matlabint_mesh_fem();
  getfem::mesh_fem *mf   = &mi_mf->mesh_fem();
  std::string cmd        = in.pop().to_string();
  if (check_cmd(cmd, "nbdof", in, out, 0, 0, 0, 1)) {
    out.pop().from_integer(mf->nb_dof());
  } else if (check_cmd(cmd, "dof from cv", in, out, 0, 1, 0, 1)) {
    dal::bit_vector dof = get_cv_dof_list(mf, in);

    out.pop().from_bit_vector(dof);
  } else if (check_cmd(cmd, "ordered dof from cv", in, out, 1, 1, 0, 1)) {
    size_type cv = in.pop().to_integer(1,10000000);
    cv--;
    if (!mf->linked_mesh().convex_index().is_in(cv)) 
      THROW_BADARG( "Convex " << cv << " is not part of the mesh"); 
    
    check_cv_fem(*mf, cv);

    getfem::ref_mesh_dof_ind_ct cvdof = mf->ind_dof_of_element(cv);
    getfem::ref_mesh_dof_ind_ct::const_iterator it;
    mlab_vect w = out.pop().create_vector(std::distance(cvdof.begin(), cvdof.end()));
    size_type i = 0;
    for (it = cvdof.begin(); it != cvdof.end(); ++it, i++) {
      w[i] = double(*it + 1);
    }
  } else if (check_cmd(cmd, "non conformal dof", in, out, 0, 1, 0, 1)) { 
    non_conformal_dof(*mf, in, out);
  } else if (check_cmd(cmd, "qdim", in, out, 0, 0, 0, 1)) {
    out.pop().from_integer(mf->get_qdim());
  } else if (check_cmd(cmd, "fem", in, out, 0, 1, 0, 2)) {
    get_fem_or_integ_of_convexes(*mf, in, out, FEM_CLASS_ID);
  } else if (check_cmd(cmd, "integ", in, out, 0, 1, 0, 2)) {
    get_fem_or_integ_of_convexes(*mf, in, out, INTEG_CLASS_ID);
  } else if (check_cmd(cmd, "is_lagrangian", in, out, 0, 1, 0, 1)) {
    test_fems(IS_LAGRANGE , mf, in, out);
  } else if (check_cmd(cmd, "is_equivalent", in, out, 0, 1, 0, 1)) {
    test_fems(IS_EQUIVALENT, mf, in, out);
  } else if (check_cmd(cmd, "is_polynomial", in, out, 0, 1, 0, 1)) {
    test_fems(IS_POLYNOMIAL, mf, in, out);
  } else if (check_cmd(cmd, "eltm", in, out, 2, 2, 0, 1)) {
    getfem::pmat_elem_type pmet = in.pop().to_mat_elem_type();
    id_type cv                  = in.pop().to_integer(1,1000000000);
    cv--; /* from matlab numbering to getfem numbering */

    if (!(mf->linked_mesh().convex_index().is_in(cv))) 
      THROW_BADARG( "The convex " << cv << " in not part of the mesh");

    /* one should check that the fem given to the MET is 
       compatible with the fem of the element (not easy ..) */
    getfem::base_tensor t;

    /* if the convex has a FEM, then it has been added to the convex index 
       of the mesh_fem 
    */
    check_cv_fem(*mf, cv);
    getfem::pmat_elem_computation pmec = 
      getfem::mat_elem(pmet, 
		       mf->int_method_of_element(cv) , 
		       mf->linked_mesh().trans_of_convex(cv));
    pmec->gen_compute(t, mf->linked_mesh().points_of_convex(cv), cv);
    out.pop().from_tensor(t);
  } else if (check_cmd(cmd, "eltm on face", in, out, 3, 3, 0, 1)) {
    getfem::pmat_elem_type pmet = in.pop().to_mat_elem_type();
    id_type cv = in.pop().to_integer(1); 
    cv--;
    if (!(mf->linked_mesh().convex_index().is_in(cv))) 
      THROW_BADARG( "The convex " << cv << " in not part of the mesh");
    /* if the convex has a FEM, then it has been added to the convex index 
       of the mesh_fem 
    */
    check_cv_fem(*mf, cv);
    id_type f = in.pop().to_integer(1, mf->linked_mesh().structure_of_convex(cv)->nb_faces());
    f--;
    getfem::base_tensor t;
    getfem::pmat_elem_computation pmec = 
      getfem::mat_elem(pmet, 
		       mf->int_method_of_element(cv) , 
		       mf->linked_mesh().trans_of_convex(cv));
    pmec->gen_compute_on_face(t, mf->linked_mesh().points_of_convex(cv), f, cv);
    out.pop().from_tensor(t);
  } else if (check_cmd(cmd, "boundaries", in, out, 0, 0, 0, 1)) {
    mlab_vect w = out.pop().create_vector(mf->get_valid_boundaries().card());
    size_type i=0; 
    for (dal::bv_visitor k(mf->get_valid_boundaries()); !k.finished(); ++k, ++i) {
      w[i] = (double)k;
    }
    if (i != w.size()) THROW_INTERNAL_ERROR;
  } else if (check_cmd(cmd, "boundary", in, out, 1, 1, 0, 1)) {
    int bnum = in.pop().to_integer(1,100000);
    std::vector<unsigned> cvlst;
    std::vector<unsigned> facelst;
    for (dal::bv_visitor cv(mf->linked_mesh().convex_index()); !cv.finished(); ++cv) {
      if (mf->is_convex_on_boundary(cv,bnum)) {
	/* loop over faces belonging to the boundary */
	for (dal::bv_visitor f(mf->faces_of_convex_on_boundary(cv,bnum)); !f.finished(); ++f) {
	  cvlst.push_back(cv);
	  facelst.push_back(f);
	}
      }
    }
    mlab_vect w = out.pop().create_vector(2, cvlst.size());
    for (size_type j=0; j < cvlst.size(); j++) { w(0,j) = cvlst[j]+1; w(1,j) = facelst[j]+1; }
  } else if (check_cmd(cmd, "dof nodes", in, out, 0, 1, 0, 2)) {
    dal::bit_vector dof_lst; dof_lst.add(0, mf->nb_dof());
    if (in.remaining())
      dof_lst = in.pop().to_bit_vector(&dof_lst);
    mlab_vect w = out.pop().create_vector(mf->linked_mesh().dim(), dof_lst.card());
    size_type j = 0;
    for (dal::bv_visitor dof(dof_lst); !dof.finished(); ++dof, ++j) {
      if (mf->point_of_dof(dof).size() != w.getm() || j >= w.getn()) THROW_INTERNAL_ERROR;
      for (size_type i=0; i < w.getm(); i++) w(i,j)= mf->point_of_dof(dof)[i];
      //      std::copy(mf->point_of_dof(dof).begin(),mf->point_of_dof(dof).end(), &w(0,j));
    }
  } else if (check_cmd(cmd, "save", in, out, 1, 2, 0, 0)) {
    std::string s = in.pop().to_string();
    bool with_mesh = false;
    if (in.remaining()) {
      if (cmd_strmatch(in.pop().to_string(), "with mesh")) {
	with_mesh = true;
      } else THROW_BADARG("expecting string 'with mesh'");
    }
    std::ofstream o(s.c_str());
    if (!o) THROW_ERROR("impossible to write in file '" << s << "'");
    o << "% GETFEM MESH+FEM FILE " << endl;
    o << "% GETFEM VERSION " << GETFEM_VERSION << endl;
    if (with_mesh) mf->linked_mesh().write_to_file(o);
    mf->write_to_file(o);
    o.close();
  } else if (check_cmd(cmd, "char", in, out, 0, 0, 0, 1)) {
    std::stringstream s;
    if (in.remaining() && cmd_strmatch(in.pop().to_string(),"with mesh"))
      mf->linked_mesh().write_to_file(s);
    mf->write_to_file(s);
    out.pop().from_string(s.str().c_str());
  } else if (check_cmd(cmd, "linked mesh", in, out, 0, 0, 0, 1)) {
    out.pop().from_object_id(mi_mf->linked_mesh_id(), MESH_CLASS_ID);
  } else if (check_cmd(cmd, "memsize", in, out, 0, 0, 0, 1)) {
    out.pop().from_integer(mf->memsize());
  } else bad_cmd(cmd);
}
