#include <matlabint_misc.h>
#include <matlabint_workspace.h>
#include <matlabint_mesh_fem.h>
#include <matlabint_mesh.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION I = gf_mesh_fem(mesh M [, int Qdim=1])

  General constructor for mesh_fem object. Returns a getfem handle 
  to the newly created mesh_fem object.

  * MF[,M] = gf_mesh_fem('load', fname[, mesh M])
  Loads a mesh_fem from a file. If the mesh M is not supplied (this
  kind of file does not store the mesh), then it is read from the file
  and its descriptor is returned as the second output argument.

  * MF[,M] = gf_mesh_fem('from string', str[, mesh M])
  Creates a mesh_fem object from its string description (which can
  be obtained with gf_mesh_fem_get(mf,'char'))

  $Id: gf_mesh_fem.C,v 1.2 2003/07/25 09:04:30 pommier Exp $
MLABCOM*/

void gf_mesh_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) THROW_BADARG("Wrong number of input arguments");
  matlabint_mesh *mm = NULL;
  matlabint_mesh_fem *mmf = NULL;
  unsigned q_dim = 1;
  if (in.front().is_string()) {
    std::string cmd = in.pop().to_string();
    if (check_cmd(cmd, "load", in, out, 1, 2, 0, 1)) {
      std::string fname = in.pop().to_string();
      if (in.remaining()) mm = in.pop().to_matlabint_mesh();
      else {
	mm = new matlabint_mesh();
	mm->mesh().read_from_file(fname);
	workspace().push_object(mm);
      }
      mmf = new matlabint_mesh_fem(mm,q_dim);
      mmf->mesh_fem().read_from_file(fname);
    } else if (check_cmd(cmd, "from string", in, out, 1, 2, 0, 1)) {
      std::stringstream ss(in.pop().to_string());
      if (in.remaining()) mm = in.pop().to_matlabint_mesh();
      else {
	mm = new matlabint_mesh();
	mm->mesh().read_from_file(ss);
	workspace().push_object(mm);
      }
      mmf = new matlabint_mesh_fem(mm,q_dim);
      mmf->mesh_fem().read_from_file(ss);
    } else bad_cmd(cmd);
    out.pop().from_object_id(workspace().push_object(mmf), MESHFEM_CLASS_ID);      
  } else {
    if (in.narg()  >  2) THROW_BADARG("Wrong number of input arguments");
    if (out.narg() != 1) THROW_BADARG("Wrong number of output arguments");
    mm = in.pop().to_matlabint_mesh();
    if (in.remaining()) q_dim = in.pop().to_integer(0,256);
    mmf = new matlabint_mesh_fem(mm,q_dim);
    out.pop().from_object_id(workspace().push_object(mmf), MESHFEM_CLASS_ID);

  }
  workspace().set_dependance(mmf, mm);
}

