#include <matlabint_misc.h>
#include <matlabint_pfem.h>

using namespace matlabint;
/*MLABCOM
  FUNCTION F=gf_fem(string FEM_NAME)
    Returns a handle F to one of the various Finite Elements Method defined
    in Getfem.

    example of fem_names are:
    * FEM(5_(BPK(N,K)
      classical Lagrange element PK on a simplex of dimension N
    * FEM(5_(BPK(5_(BDISCONTINUOUS(N,K)} 
       discontinuous Lagrange element PK on a simplex of dim N
    * FEM(5_(BQK(N,K)}      
      classical Lagrange element QK on quadrangles, hexahedrons etc
    * FEM(5_(BPK(5_(BPRISM(N,K) 
      classical Lagrange element PK on a prism
    * FEM(5_(BPK(5_(BWITH(5_(BCUBIC(5_(BBUBBLE(N,K)   
      classical Lagrange element PK on a simplex with an additional volumic bubble function.
    * FEM(5_(BPRODUCT(FEM1,FEM2)
      tensorial product of two polynomial elements
    * FEM(5_(BP1(5_(BNONCONFORMING 
      non-conforming P1 method on a triangle.
    * FEM(5_(BP1(5_(BBUBBLE(5_(BFACE(N)   
      P1 method on a simplex with an additional bubble function on face 0.
    * FEM(5_(BP1(5_(BBUBBLE(5_(BFACE(5_(BLAG  
      P1 method on a simplex with an additional lagrange dof on face 0.
    * FEM(5_(BHERMITE(5_(BSEGMENT       
      Hermite element on the segment
    * FEM(5_(BPK(5_(BHIERARCHICAL(N,K)  
      PK element with a hierarchical basis
    * FEM(5_(BQK(5_(BHIERARCHICAL(N,K)  
      QK element with a hierarchical basis
    * FEM(5_(BPK(5_(BPRISM(5_(BHIERARCHICAL(N,K)   
      PK element on a prism with a hierarchical basis
    * FEM(5_(BSTRUCTURED(5_(BCOMPOSITE(FEM, K) 
      Composite fem on a grid with K divisions
    * FEM(5_(BPK(5_(BHIERARCHICAL(5_(BCOMPOSITE(N,K,S)
      PK composite element on a grid with S subdivisions and with a hierarchical basis
    * FEM(5_(BPK(5_(BFULL(5_(BHIERARCHICAL(5_(BCOMPOSITE(N,K,S) 
      PK composite element with S subdivisions and a hierarchical basis on both degree and subdivision

MLABCOM*/

void gf_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(matlabint::ind_pfem(getfem::fem_descriptor(cmd)), FEM_CLASS_ID);
}
