function [varargout] = subsref(im,index)
% gfInteg/SUBSREF Define field name indexing for gfInteg objects
%  accessible methods:
%    im.id  
%    im.is_exact
%    im.nbpts
%    im.pts
%    im.coeffs
%    ...etc

  nout = max(nargout,1);  
  switch index(1).type
   case '()'
    error('indexes not supported');
   case '.'
    if (strcmp(index(1).subs,'id'))
      varargout{1} = im.id;
    else
      varargout{1} = gf_integ_get(im,index(1).subs);
    end;
   case '{}'
    error('cell access not supported');
  end
  if (numel(index) > 1)
    for i=1:nargout,
      varargout{i} = subsref(varargout{i},index(2:end));
    end;
  end;
