function check_mesh_fem(iverbose,idebug)
  global gverbose;
  global gdebug;  
  if (nargin >= 1),
    gverbose = iverbose;
    if (nargin == 2),
      gdebug = idebug;
    else 
      gdebug = 0; end;
  else 
    gverbose = 0;
  end;
  s=['BEGIN POINTS LIST' 10,...
     'POINT  0  0 0 0' 10,...
     'POINT  1  -4 6 2' 10,...
     'POINT  2  0 6 0' 10,...
     'POINT  3  0 2 0' 10,...
     'POINT  4  -2 6 2' 10,...
     'POINT  5  0 4 0' 10,...
     'POINT  6  -1.5 4.5 .5' 10,...
     'POINT  7  1 2 0' 10,...
     'POINT  8  1.5 1.5 0' 10,...
     'POINT  9   5 5 0' 10,...
     'POINT  10  2 1 0' 10,...
     'POINT  11  6 3 0' 10,...
     'POINT  12  2 0 0' 10,...
     'POINT  13  6 0 0' 10,...
     'POINT  14  2 4 0' 10,...
     'POINT  15  4 2 0' 10,...
     'POINT  46  4 4 0' 10,...
     'POINT  17  3 6 0' 10,...
     'POINT  18  2 -2 2' 10,...
     'POINT  19  2 -2 -2' 10,...
     'POINT  20  6 -2 2' 10,...
     'POINT  21  6 -2 -2' 10,...
     'POINT  22  2 -1 1' 10,...
     'POINT  23  2 -2.5 0' 10,...
     'POINT  24  2 -1 -1' 10,...
     'POINT  25  6 -1 1' 10,...
     'POINT  26  6 -2.5 0' 10,...
     'POINT  27  6 -1 -1    ' 10,...
     'POINT  28  -1 6 -1 ' 10,...
     'POINT  29  -1 2 -1' 10,...
     'POINT  30  +1 6 -2' 10,...
     'POINT  31  +1 2 -2' 10,...
     'POINT  32  0 6 -3' 10,...
     'POINT  33  0 2 -3' 10,...
     'POINT  34  2 -5 -2' 10,...
     'POINT  35  2 -4 0' 10,...
     'POINT  36  4 -5 2' 10,...
     'POINT  37  6 -5 -2' 10,...
     'POINT  38  6 -5 0' 10,...
     'POINT  49  6 -5 2' 10,...
     'END POINTS LIST' 10,...
     'BEGIN MESH STRUCTURE DESCRIPTION' 10,...
     'CONVEX 0    GT_PK(2,2)      1 4 2 6 5 3' 10,...
     'CONVEX 1    GT_QK(2,1)      2 17 3 7' 10,...
     'CONVEX 2    GT_QK(2,2)      7 8 10 14 46 15 17 9 11' 10,...
     'CONVEX 3    GT_QK(2,1)      10 12 11 13' 10,...
     'CONVEX 4    GT_PRODUCT(GT_PK(2,2),GT_PK(1,1)) 12 22 18 24 23 19 13 25 20 27 26 21' 10,...
     'CONVEX 5    GT_PRODUCT(GT_PK(1,1),GT_PK(1,3)) 2 3 28 29 30 31 32 33' 10,...
     'CONVEX 8    GT_PRODUCT(GT_PK(1,2),GT_QK(2,1)) 19 23 18 21 26 20 34 35 36 37 38 49' 10,...
     'END MESH STRUCTURE DESCRIPTION' 10,...
     'BEGIN MESH_FEM' 10,...
     ' CONVEX 0 FEM_PK(2,2) IM_TRIANGLE(6)' 10,...
     ' CONVEX 1 FEM_QK(2,2) IM_QUAD(5)' 10,...
     ' CONVEX 2 FEM_QK(2,3) IM_QUAD(5)' 10,...
     ' CONVEX 3 FEM_QK(2,2) IM_QUAD(3)' 10,...
     ' CONVEX 4 FEM_PRODUCT(FEM_PK(2,2),FEM_PK(1,2)) IM_PRODUCT(IM_TRIANGLE(5),IM_GAUSS1D(5))' 10,...
     ' CONVEX 5 FEM_PRODUCT(FEM_PK(1,2),FEM_PK(1,3)) IM_PRODUCT(IM_GAUSS1D(5),IM_GAUSS1D(5))' 10,...
     ' CONVEX 8 FEM_PRODUCT(FEM_PK(1,2),FEM_QK(2,3)) IM_PRODUCT(IM_GAUSS1D(5),IM_QUAD(5))' 10,...
     'END MESH_FEM\n'];
  m=gf_mesh('from string',s);
  mf=gf_mesh_fem('from string',s,m);
  s2=gf_mesh_fem_get(mf,'char');
  mf2=gf_mesh_fem('from string',s2,m);
  gf_mesh_fem_get(mf,'nbdof')
  gf_mesh_fem_get(mf2,'nbdof')
  
  N=gf_mesh_get(m,'dim');
  npt=gf_mesh_get(m,'nbpts');
  assert('N==3 & npt==40');
  ncv=gf_mesh_get(m,'nbcvs');
  assert('ncv==7');
  lastcv=gf_mesh_get(m, 'max cvid');
  assert('lastcv==9');
  lastpid=gf_mesh_get(m, 'max pid');
  assert('lastpid==50');
  [d,c]=gf_mesh_get(mf, 'pid from cvid',[2 6]);
  assert('c==[1 5 13]');
  assert('d==[3 18 4 8 3 4 29 30 31 32 33 34]');
  [d,c]=gf_mesh_get(mf, 'pid from cvid',1:gf_mesh_get(m,'max cvid'));
  [d,c]=gf_mesh_get(mf, 'pid from cvid');
  for i=[-1 0 -10],
    asserterr('gf_mesh_get(m, ''pid from cvid'',i)');
  end;
  P=gf_mesh_get(m,'pts');
  V=gf_mesh_get(m, 'pid from coords', P);
  pid=gf_mesh_get(m,'pid');
  assert('find(V~=-1)==pid');
  a=gf_mesh_get(m, 'faces from pid', pid);
  b=[1 1 1 2 1 3 6 1 6 2 6 3 6 4 2 1 2 2 2 3 2 4 3,...
     1 3 2 3 3 3 4 4 1 4 2 4 3 4 4 5 1 5 2 5 3 5 4,...
     5 5 9 1 9 2 9 3 9 4 9 5 9 6];
  assert('a(:)==b(:)');  

  
  for i=[-1 0 48 49]
    asserterr('gf_mesh_get(m, ''faces from pid'', i)');
  end;
  a=gf_mesh_get(m, 'outer faces');
  b=[1 0 2 0 3 0 4 0 5 2 5 3 5 4 5 5 6 0 9 1 9 2 9 3 9 4 9 5];
  assert('a(:)==b(:)');
  a=gf_mesh_get(m, 'outer faces',[4 5]);
  assert('a(:)==[4 0 5 1 5 2 5 3 5 4 5 5]''');
  asserterr('gf_mesh_get(m, ''outer faces'',[4 6 7 8])');
  asserterr('gf_mesh_get(m, ''outer faces'',[0])');
  E=gf_mesh_get(m, 'edges');
  asserterr('gf_mesh_get(m, ''edges'',[0])');
  E=gf_mesh_get(m, 'curved edges',10);
  E=gf_mesh_get(m, 'curved edges',8);
  asserterr('gf_mesh_get(m, ''curved edges'',-1)');
  assert('abs(sum(sum(sum(E)))-1.872e3) < 2');
  asserterr('gf_mesh_get(m, ''triangulated surface'', 3)');
  Z=gf_mesh_get(m, 'triangulated surface', 4,gf_mesh_get(m, 'outer faces',[4 5]));
  assert('size(Z)==[9 160]');
  Z=gf_mesh_get(m, 'curved edges', 4, gf_mesh_get(m, 'outer faces',[4 5]));
  ZZ=gf_mesh_get(m, 'curved edges', 4, [4 5]);
  for i=0:7
    if (i > 0 & i < 7),
      n=gf_mesh_get(m, 'normal of face', 5, 3, i);
      assert('norm(n-[0    0.7071    0.7071]) < 1e-3');
      nn(i,:)=gf_mesh_get(m, 'normal of face', 5, 1, i);
    else
      asserterr('gf_mesh_get(m, ''normal of face'', 5, 3, i)');
    end;
  end;
  zz=[0 0 0 0 0 0 -0.894427 -1 -0.894427 -0.894427 -1 -0.894427 0.447214 0 -0.447214 0.447214 0 -0.447214];  
  assert('norm(nn(:)''-zz)<1e-5'); %8.9465e-07
  asserterr('gf_mesh_get(m, ''normal of faces'', [1 -1])');
  N=gf_mesh_get(m, 'normal of faces', gf_mesh_get(m, 'outer faces',[5 9]));
  s2=gf_mesh_get(m,'char');
  assert('length(s2)>500');
  m2=gf_mesh('from string',s);

  gf_mesh_fem_get(mf,'nbdof');
  d=gf_mesh_fem_get(mf,'dof from cv',[1 5]);
  assert(['d==[1 2 3 4 5 6 37 40 42 43 44 45 46 47 48 49 50 51 52 53 54 55 ' ...
          '56 57]']);
  d=gf_mesh_fem_get(mf,'dof from cv',[1 5;1 2]);
  assert('d==[3 5 6 37 40 42 45 47 50 52 55 57]');
  d=gf_mesh_fem_get(mf,'ordered dof from cv',5);
  assert('d==[37 43 44 45 46 47 40 48 49 50 51 52 42 53 54 55 56 57]');
  
  s2=gf_mesh_get(mf,'char');
  assert('length(s2)>500');
  m2=gf_mesh('from string',s);
  mf2=gf_mesh_fem('from string',s);
  mf3=gf_mesh_fem('from string',s,m2);
  gf_mesh_fem_set(mf2,'qdim',2);
  s2=gf_mesh_fem_get(mf2,'char');
  s3=gf_mesh_get(mf2,'char');
  % ~bug here: doesn't work if s2 and s3 are reversed
  mf2=gf_mesh_fem('from string',[s3 s2]); 
  
  
  d=gf_mesh_fem_get(mf2,'dof from cv',[1 5]);
%  dd=[1 2 3 4 5 6 7 8 9 10 11 12 73 74 79 80 83 84 85 86 87 88 89 90 91 92 ...
%      93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 ...
%      112 113 114];
%  assert('d==dd');
  
  d=gf_mesh_fem_get(mf2,'dof from cv',[1 5;1 2]);
%  dd=[5 6 9 10 11 12 73 74 79 80 83 84 89 90 93 94 99 100 103 104 109 110 113 ...
%      114];  
%  assert('d==dd');
  d=gf_mesh_fem_get(mf2,'ordered dof from cv',5);
%  dd=[73 74 85 86 87 88 89 90 91 92 93 94 79 80 95 96 97 98 99 100 101 102 ...
%      103 104 83 84 105 106 107 108 109 110 111 112 113 114];  
%  assert('d==dd');

  [f,c]=gf_mesh_get(mf2, 'geotrans');
  assert('c(2)==c(4)');

  fs1=gf_geotrans_get(f(c(6)),'char');
  assert('fs1==''GT_PRODUCT(GT_PK(1,1),GT_PK(1,3))''');
  [f,c]=gf_mesh_get(mf2, 'cvstruct');
  assert('c(2)==c(4)');
  [f,c]=gf_mesh_fem_get(mf2, 'fem');
  assert('c(2)==c(4)');
  fs1=gf_fem_get(f(c(5)),'char');
  assert('fs1==''FEM_PRODUCT(FEM_PK(2,2),FEM_PK(1,2))''');
  [f,c]=gf_mesh_fem_get(mf2, 'integ');
  assert('c(2)==c(3)');
  fs1=gf_integ_get(f(c(3)),'char');
  assert('fs1==''IM_QUAD(5)''');
  
  %test for non conformal dof
  m = gf_mesh('triangles grid',[0:.5:1], [0:.5:1]);
  mf_u = gf_mesh_fem(m,2);
  mf_d = gf_mesh_fem(m,1);
  gf_mesh_fem_set(mf_u,'fem',gf_fem('FEM_PK(2,1)'), ...
                  gf_integ('IM_EXACT_SIMPLEX(2)'),[1:5 7]);
  gf_mesh_fem_set(mf_u,'fem',gf_fem('FEM_PK(2,3)'), gf_integ('IM_EXACT_SIMPLEX(2)'),8);
  gf_mesh_fem_set(mf_d,'fem',gf_fem('FEM_PK(2,1)'), gf_integ('IM_EXACT_SIMPLEX(2)'));
  gf_mesh_fem_set(mf_u, 'boundary', 3, [1 1 1; 1 2 3]);
  gf_mesh_fem_set(mf_u, 'boundary', 7, [3 4; 3 2]);
  cl=[1:5 7 8];
  asserterr('gf_mesh_fem_get(mf_u, ''non conformal dof'')');
  d=gf_mesh_fem_get(mf_u, 'non conformal dof',cl);
  %gf_plot_mesh(mf_u, 'dof', 'on');
  assert('d==[13 14 15 16 19 20 25 26]');

  f=gf_mesh_fem_get(mf2, 'fem');
  f5=gf_mesh_fem_get(mf2, 'fem',5);
  asserterr('gf_mesh_fem_get(mf_u, ''fem of cvs'')');
  asserterr('gf_mesh_fem_get(mf_u, ''fem of cvs'',7)');
  asserterr('gf_mesh_fem_get(mf_u, ''fem of cvs'',6)');
  gf_mesh_fem_get(mf_u, 'is_lagrangian',cl);
  gf_mesh_fem_get(mf_u, 'is equivalent',cl);
  gf_mesh_fem_get(mf_u, 'is_polynomial',cl);
  
  
  
  me=gf_eltm('base', f5);
  ME=gf_mesh_fem_get(mf2,'eltm',me,5);
  MME=[-0.0444444 1.15556 0.0222222 1.15556 1.24444 0.0222222 -0.177778 4.62222,...
       0.0888889 4.62222 4.97778 0.0888889 -0.0444444 1.15556 0.0222222 1.15556,...
       1.24444 0.0222222]';
  assert('norm(ME-MME)<1e-4');
  oo=gf_mesh_get(mf2,'outer faces');
  oo=oo(:,find(oo(2,:)~=0));
  gf_mesh_fem_set(mf2,'boundary',51,oo);
  o=gf_mesh_fem_get(mf2,'boundary',51);
  assert('size(o)==size(oo) & sum(sum(o))==sum(sum(oo))');
  o=gf_mesh_fem_get(mf2,'boundary',1);
  assert('isempty(o)');
  gf_mesh_fem_set(mf2,'boundary',1,oo(:,1));
  o=gf_mesh_fem_get(mf2,'boundary',1);
  assert('o==oo(:,1)');

  o=gf_mesh_fem_get(mf2,'boundaries');
  assert('o==[1 51]');
  
  gf_mesh_fem_set(mf2,'delete boundary',1);
  o=gf_mesh_fem_get(mf2,'boundary',1);
  assert('isempty(o)');
  o=gf_mesh_fem_get(mf2,'boundaries');
  assert('o==51');
  
  m=gf_mesh_fem_get(mf2,'linked_mesh');
  asserterr('gf_mesh_set(m, ''del point'', [3])');
  o=gf_mesh_get(m,'pid from cvid', 3);
  assert('o==[8 9 11 15 47 16 18 10 12]');

  gf_mesh_set(m,'del convex',3);
  gf_mesh_set(m,'del convex',2);
  c=[2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 18 19 20 21 22 23 24 25,...
     26 27 28 29 30 31 32 33 34 35 36 37 38 39 47 50];
  d=gf_mesh_get(m,'pid');
  assert('d(:)==c(:)');
  

  
  % test for optimize_structure
  maxpid=gf_mesh_get(m,'max pid');
  maxcvid=gf_mesh_get(m,'max cvid');
  np=gf_mesh_get(m,'nbpts');
  ncv=gf_mesh_get(m,'nbcvs');
  assert('np < maxpid');
  assert('ncv < maxcvid');

  gf_mesh_set(m,'optimize structure');
  maxpid=gf_mesh_get(m,'max pid');
  maxcvid=gf_mesh_get(m,'max cvid');
  assert('np == maxpid');
  assert('ncv == maxcvid');

  gf_mesh_set(m,'del convex',2);