function check_asm(iverbose,idebug)
  global gverbose;
  global gdebug;  
  if (nargin >= 1),
    gverbose = iverbose;
    if (nargin == 2),
      gdebug = idebug;
    else 
      gdebug = 0; end;
  else 
    gverbose = 0;
  end;
  gf_workspace('clear all');
  p=[0 1 0 1.5; 0 0 1 1];
  t=[1 2 3 0; 2 3 4 0]';
  m=gf_mesh('pt2D',p,t);
  z=rand(200,22);
  zz=rand(200,22);
  z=z+zz;
  clear z;
  zzz=rand(200,22);
  zz=zz+zz;
  pack;
  mf=gf_mesh_fem(m,1);
  asserterr('gf_asm(''volumic'',''V(#1)+=comp(Base(#1))'',mf)');
  mf3=gf_mesh_fem(m,3);
  gf_mesh_fem_set(mf,'fem',gf_fem('FEM_PK(2,1)'),gf_integ('IM_EXACT_SIMPLEX(2)'));
  gf_mesh_fem_set(mf3,'fem',gf_fem('FEM_PK(2,2)'),gf_integ('IM_TRIANGLE(3)'));
  v=gf_asm('volumic','V(#1)+=comp(Base(#1))',mf);
  asserterr('gf_asm(''volumic'',''V(#1)+=comp(Base(#2))'',mf)');
  X=gf_asm('volumic','V(#1,#2)+=comp(Base(#1).Base(#1))',mf,mf);
  assert('max(abs((X-X'')))<1e-15');
  X=gf_asm('volumic','V(#1,#1,#1,#1)+=comp(Base(#1).Base(#1).Base(#1).Base(#1))',mf);
  assert('size(X)==[4 4 4 4]');
  X=gf_asm('volumic','M(#1,#2)+=comp(Grad(#1).vBase(#2))(:,z,:,i)',mf,mf3);

  pack;
  assert('size(X)==[4 27]');
  assert('abs(sum(sum(abs(X)))-10.5) < 2e-15');
  asserterr('gf_asm(''volumic'',''V(#1)+=comp(Base(#1))'',mf3)');
  X=gf_asm('volumic','V(qdim(#1),#1)+=comp(vBase(#1)){2,1}',mf3);
  assert('nnz(X)==27');
  xnnz=find(X);
  zz=[1 5 9 10 14 18 19 23 27 28 32 36 37 41 45 46 50 54 55 59 63 64 68 72 ...
      73 77 81];
  assert('xnnz(:)==zz(:)');
  X2=gf_asm('volumic','V(3,#1)+=comp(vBase(#1)){2,1}',mf3);
  assert('X2==X');
  X=gf_asm('volumic','V(#1,mdim(#1),mdim(#1))+=comp(Hess(#1))',mf);
  assert('X==0');
  X=gf_asm('volumic','V(#1,qdim(#1),mdim(#1),mdim(#1))+=comp(vHess(#1))',mf3);
  assert('abs(sum(sum(sum(sum(X))))) < 1e-14');
  asserterr('gf_asm(''volumic'',''V(#1)+=1'')');
  
  
  
