#include <map>
#include <matlabint_misc.h>
#include <matlabint_mesh.h>
#include <matlabint_mesh_slice.h>
#include <getfem_mesh_slice.h>

using namespace matlabint;

/*MLABCOM

  FUNCTION [...] = gf_slice_set(sl, operation)

  Edition of mesh slices.

  * I = gf_slice_set(sl, 'pts', mat P)
  
  Replaces the original points of the slice sl with points P (stored
  in the columns the matrix). Note that you can use the function to
  apply a deformation to a slice, or to change the dimension of the
  slice (i.e.  the number of rows of P is not required to be equal to
  gf_slice_get(sl,'dim')).

  $Id: gf_slice_set.C,v 1.3 2003/07/23 18:31:14 pommier Exp $
MLABCOM*/


void gf_slice_set(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 2) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  matlabint_mesh_slice *mi_sl = in.pop().to_matlabint_mesh_slice();
  getfem::mesh_slice *sl = &mi_sl->mesh_slice();
  std::string cmd                  = in.pop().to_string();
  if (check_cmd(cmd, "pts", in, out, 1, 1, 0, 0)) {
    mlab_vect w = in.pop().to_scalar_vector(-1, sl->nb_points());
    size_type min_dim = 0;
    for (size_type ic=0; ic < sl->nb_convex(); ++ic) {
      for (getfem::mesh_slice::cs_simplexes_ct::const_iterator it = sl->simplexes(ic).begin();
	   it != sl->simplexes(ic).end(); ++it)
	min_dim = std::max(min_dim, it->dim());
    }
    if (w.getm() < min_dim) 
      DAL_THROW(matlabint_error, "can't reduce the dimension of the slice to " << 
		w.getm() << " (it contains simplexes of dimension " << min_dim << ")");
    sl->set_dim(w.getm()); /* resize the points */
    for (size_type ic=0, cnt=0; ic < sl->nb_convex(); ++ic) {
      for (getfem::mesh_slice::cs_nodes_ct::iterator it=sl->nodes(ic).begin();
           it != sl->nodes(ic).end(); ++it) {
        for (size_type k=0; k < sl->dim(); ++k)
          (*it).pt[k] = w[cnt++];
      }
    }
  } else bad_cmd(cmd);
}
