/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom) version 1.0                        */
/* File    : gf_delete.C : deletes a getfem object                         */
/*     									   */
/*                                                                         */
/* Date : August 2002.                                                     */
/* Author : Julien Pommier, pommier@@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include <matlabint.h>
#include <matlabint_workspace.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION gf_delete(I,[J,K,...])
 
    Deletes an existing getfem object from memory (integer set, polynomial, 
    mesh, mesh_fem). i should be a descriptor given by new_intset, new_mesh, 
    new_mesh_fem, etc..

    Note that if another object uses I, then object I will be deleted only
    when both have been asked for deletion.

  SEE ALSO:
    gf_workspace,gf_mesh, gf_mesh_fem.
 MLABCOM*/

void gf_delete(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.remaining() < 1)
    THROW_BADARG("Wrong number of input arguments, should be at least 1.");
  if (out.narg() != 0)
    THROW_BADARG("No output argument needed.");
  
  while (in.remaining()) {
    id_type id, cid; in.pop().to_object_id(&id,&cid);
    if (cid != MESHFEM_CLASS_ID &&
	cid != MESH_CLASS_ID &&
	cid != SLICE_CLASS_ID &&
	cid != POLY_CLASS_ID) {
      THROW_BADARG("sorry, objects of type " << name_of_getfemint_class_id(cid) << " are static, i.e. they can't be deleted");
    }
    if (matlabint::workspace().object(id)) { /* throw an exeption if object not found */
      matlabint::workspace().delete_object(id);
    } else {
      GFI_WARNING("ouuups strange");
    }
  }
}

