#include <matlabint.h>
#include <matlabint_convex_structure.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION I = gf_cvstruct_get(cs, ...)
    General function for querying information about convex_structure objects.
    
    * I=gf_cvstruct_get(cs, 'nbpts')

    * I=gf_cvstruct_get(cs, 'dim')

    * cs=gf_cvstruct_get(cs, 'basic structure') 
    returns the structure off the basic convex (i.e. for a 6-nodes triangle, it
    returns the structure of the canonical 3-noded triangle).

    * cs=gf_cvstruct_get(cs, 'face', int F)
    returns the structure of the face F.

    * I=gf_cvstruct_get(cs, 'facepts', int F)
    returns the list of point indices for the face F

MLABCOM*/

void gf_cvstruct_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 2) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  bgeot::pconvex_structure cs = in.pop().to_convex_structure();
  std::string cmd = in.pop().to_string();
  if (check_cmd(cmd, "nbpts", in, out, 0, 0, 0, 1)) {
    out.pop().from_scalar(cs->nb_points());
  } else if (check_cmd(cmd, "dim", in, out, 0, 0, 0, 1)) {
    out.pop().from_scalar(cs->dim());
  } else if (check_cmd(cmd, "basic_structure", in, out, 0, 0, 0, 1)) {
    out.pop().from_object_id(matlabint::ind_convex_structure(cs->basic_structure()),
			     CVSTRUCT_CLASS_ID);
  } else if (check_cmd(cmd, "face", in, out, 1, 1, 0, 1)) {
    size_type f = in.pop().to_integer(1,cs->nb_faces()) - 1;
    out.pop().from_object_id(matlabint::ind_convex_structure(cs->faces_structure()[f]),
			     CVSTRUCT_CLASS_ID);    
  } else if (check_cmd(cmd, "facepts", in, out, 1, 1, 0, 1)) {
    size_type f = in.pop().to_integer(1,cs->nb_faces()) - 1;
    mlab_vect w = out.pop().create_vector(cs->nb_points_of_face(f));
    for (size_type i=0; i < w.size(); ++i) w[i] = cs->ind_points_of_face(f)[i]+1;
  } else bad_cmd(cmd);
}


