#include <matlabint.h>

using namespace matlabint;

void gf_workspace(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_delete(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_eltm(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_geotrans(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_geotrans_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_integ(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_integ_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_fem_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_cvstruct_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh_set(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh_fem_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_mesh_fem_set(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_slice(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_slice_get(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_slice_set(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_asm(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_compute(matlabint::mexargs_in& in, matlabint::mexargs_out& out);
void gf_util(matlabint::mexargs_in& in, matlabint::mexargs_out& out);

namespace matlabint {
  std::stringstream *global_pinfomsg = 0;
  std::ostream& infomsg() {
    return *global_pinfomsg;
  }
}

extern "C" 
char* getfem_matlab_main(const char *function, 
                         int nb_in_args,
                         const gfi_array *in_args[], 
                         int nb_out_args,
                         gfi_array *out_args[], char **pinfomsg)
{
  std::stringstream info;
  matlabint::global_pinfomsg = &info;
  *pinfomsg = 0;
  try {
    mexargs_in in(nb_in_args, in_args, false);
    mexargs_out out(nb_out_args, out_args);
    if (strcmp(function, "workspace")==0) gf_workspace(in,out);
    else if (strcmp(function, "delete")==0) gf_delete(in,out);
    else if (strcmp(function, "eltm")==0) gf_eltm(in,out);
    else if (strcmp(function, "geotrans")==0) gf_geotrans(in,out);
    else if (strcmp(function, "geotrans_get")==0) gf_geotrans_get(in,out);
    else if (strcmp(function, "integ")==0) gf_integ(in,out);
    else if (strcmp(function, "integ_get")==0) gf_integ_get(in,out);
    else if (strcmp(function, "fem")==0) gf_fem(in,out);
    else if (strcmp(function, "fem_get")==0) gf_fem_get(in,out);
    else if (strcmp(function, "cvstruct_get")==0) gf_cvstruct_get(in,out);
    else if (strcmp(function, "mesh")==0) gf_mesh(in,out);
    else if (strcmp(function, "mesh_get")==0) gf_mesh_get(in,out);
    else if (strcmp(function, "mesh_set")==0) gf_mesh_set(in,out);
    else if (strcmp(function, "mesh_fem")==0) gf_mesh_fem(in,out);
    else if (strcmp(function, "mesh_fem_get")==0) gf_mesh_fem_get(in,out);
    else if (strcmp(function, "mesh_fem_set")==0) gf_mesh_fem_set(in,out);
    else if (strcmp(function, "slice")==0) gf_slice(in,out);
    else if (strcmp(function, "slice_get")==0) gf_slice_get(in,out);
    else if (strcmp(function, "slice_set")==0) gf_slice_set(in,out);
    else if (strcmp(function, "asm")==0) gf_asm(in,out);
    else if (strcmp(function, "compute")==0) gf_compute(in,out);
    else if (strcmp(function, "util")==0) gf_util(in,out);
    else if (strcmp(function, "exit")==0) exit(1);
    else DAL_THROW(matlabint_bad_arg, "unknown function: " << function);
  } 
  catch (matlabint_bad_arg e) {
    cerr << "matlabint_bad_arg exception caught\n";
    return strdup(e.what());
  }
  catch (matlabint_error e) {
    cerr << "matlabint_error exception caught\n";
    return strdup(e.what());
  }
  catch (std::logic_error e) {
    cerr << "logic_error exception caught\n";
    return strdup(e.what());
  }
  catch (std::runtime_error e) {
    cerr << "runtime_error exception caught\n";
    return strdup(e.what());
  }
  catch(std::bad_alloc) {
    return strdup("getfem caught a bad_alloc exception\n");
  }
  catch(std::bad_cast) {
    return strdup("getfem caught a bad_cast exception\n");
  }
  catch(std::bad_typeid) {
    return strdup("getfem caught a bad_typeid exception\n");
  }
  catch(std::bad_exception) {
    return strdup("getfem caught a bad_exception exception\n");
  }
  catch (...) {
    return strdup("getfem caught an unknown exception\n");
  }
  if (!info.str().empty()) {
    *pinfomsg = strdup(info.str().c_str());
  }
  return 0;
}
