function [varargout] = subsref(sl,index)
% gfSlice/SUBSREF Define field name indexing for gfSlice objects
% you can use the following (pseudo) object members:
%   .nbpts
%   .dim
%   .id
  nout = max(nargout,1); cnt=1;
  switch index(1).type    
   case '{}'
    error('Cell array indexing not supported by gfSlice objects')
   case '.'
    switch index(1).subs
     case {'mesh','linked_mesh'}
      % extraction of the linked mesh
      [varargout{1:nout}] = gfMesh(gf_slice_get(sl, 'linked mesh'));
     case 'id'
      [varargout{1:nout}] = mf.id;
     otherwise
      [varargout{1:nout}] = gf_slice_get(mf,index(1).subs);
    end
  end
  % if there are others indexes, let matlab do its work
  if (numel(index) > cnt)
    for i=1:nout,
      varargout{i} = subsref(varargout{i},index((cnt+1):end));
    end;
  end;  
