% clears every getfem object 
gf_workspace('clear all');
clear pde;
disp('getfem_matlab basic example -- 1D laplacian with high order FEM');
disp(['this demo illustrates some current drawbacks of this getfem ' ...
      'release. Hopefully, these numerical problems with high order elements ' ...
      'will be solved soon!']);
% creation of a simple cartesian mesh
m = gf_mesh('cartesian',[0:1:100]);

% visualisation of the mesh, with the numbering
% of vertices and convexes.
gf_plot_mesh(m, 'vertices','convexes');
%disp('press enter to continue..'); pause

pde.type = 'laplacian';
pde.lambda = { 1 };
pde.mf_u = gf_mesh_fem(m,1);
pde.mf_d = gf_mesh_fem(m,1);
expr_u = 'sin(x/2)+x/100'; %sin(x).*cos(y)';
expr_f = 'sin(x/2)/4'; %'-2*sin(x).*sin(y)';
pde.bound{1}.type = 'Dirichlet';
pde.bound{1}.R = { expr_u };
pde.F = { expr_f };

mf=gf_mesh_fem(m,1);
gf_mesh_fem_set(mf,'fem',gf_fem('FEM_PK(1,4)'), gf_integ('IM_EXACT_SIMPLEX(1)'));
x = gf_mesh_fem_get(mf, 'dof nodes');
eU = eval(expr_u);

for j=1:3
  if (j==1),
    disp(['Results for the basic PK FEM.. as you can see the ' ...
          'numerical noise of PK(K>4) has an impact on our ' ...
          'evaluation of Dirichlet conditions..']);
  elseif (j==2),
    disp(['Results for the basic PK FEM with hand-made Dirichlet ' ...
          'conditions. Quite better but it is well-known that ' ...
          'polynomial basis of high order are quite bad for ' ...
          'interpolation: this has an impact on the volumic source']);
  else
      disp(['Results with the PK_HIERARCHICAL FEM and hand-made ' ...
            'dirichlet conditions. Actually the best, since the ' ...
            'hierarchical basis is much better conditionned than the ' ...
            'PK. Note that the condition number of the matrix ' ...
            'increases slower']);
  end;
  for iK=1:6,
    if (j==3), 
      K = 2*iK; % avoid prime numbers: on primes numbers, the hierarchical basic is the PK basis
    else K=iK; end;
    if (j<=2),
      fem_u=gf_fem(sprintf('FEM_PK(1,%d)',K));
      fem_d=gf_fem(sprintf('FEM_PK(1,%d)',K));
    else
      fem_u=gf_fem(sprintf('FEM_PK_HIERARCHICAL(1,%d)',K));
      fem_d=gf_fem(sprintf('FEM_PK(1,%d)',K));
    end
    
    im = gf_integ('IM_EXACT_SIMPLEX(1)');
    gf_mesh_fem_set(pde.mf_u,'fem',fem_u, im);
    gf_mesh_fem_set(pde.mf_d,'fem',fem_d, im);
    
    bord = gf_mesh_get(m,'outer faces');
    for bmf=[pde.mf_u pde.mf_d],
      gf_mesh_fem_set(bmf, 'boundary', 1, bord);
    end;
    pde2=pde;
    if (j>=2),
      nbdof = gf_mesh_fem_get(pde.mf_u, 'nbdof');
      H = sparse(nbdof,nbdof);
      R = zeros(nbdof,1);
      D=gf_mesh_fem_get(pde.mf_u,'dof nodes');
      [foo,i0]=min(D); R(i0) = eU(1);
      [foo,i1]=max(D); R(i1) = eU(end);
      H(i0,i0)=1; H(i1,i1)=1;
      pde2.asm = struct('H',H,'R',R);
    end;
    %      keyboard
    [Uu,pde2]=gf_solve(pde2);
    
    %gf_plot(pde.mf_u, U,'mesh','boundaries'); colorbar;
    U = gf_compute(pde.mf_u, Uu, 'interpolate on', mf);
    plot(x,U,'r+-',x,eU,'bx:'); legend('approx','exact');
    [mx,pos]=max(abs(eU-U));
    disp(sprintf('K=%d .. max_rel(err)=%1.10f at x=%3.2f [condition number=%e]',K,mx/max(abs(eU)), x(pos),condest(pde2.asm.RK)));
  end;
end;
