/* -*- c++ -*- (enables emacs c++ mode)                                    */
#ifndef __MATLABINT_STD_H
#define __MATLABINT_STD_H

#include <dal_std.h>
#include <dal_except.h>

namespace matlabint
{
  typedef enum { MESH_CLASS_ID, MESHFEM_CLASS_ID, GEOTRANS_CLASS_ID, 
		 FEM_CLASS_ID, INTEG_CLASS_ID, ELTM_CLASS_ID, CVSTRUCT_CLASS_ID,
		 POLY_CLASS_ID, GETFEMINT_NB_CLASS } getfemint_class_id;
  
  const char *name_of_getfemint_class_id(unsigned cid);

  void attach_gdb();

  #define THROW_INTERNAL_ERROR { DAL_THROW(matlabint::matlabint_error, "matlabint: internal error\n") }

  typedef size_t size_type;
  typedef dal::uint32_type id_type;

  #define MATLABINT_CVS_MASK         0x12000000
  #define MATLABINT_PGT_MASK         0x14000000
  #define MATLABINT_PFI_MASK         0x15000000
  #define MATLABINT_PFEM_MASK        0x16000000
  #define MATLABINT_MATELEMTYPE_MASK 0x17000000
  #define MATLABINT_MATELEM_MASK     0x18000000

  class matlabint_error : public std::logic_error {
    //    std::string _what;
  public:
    matlabint_error(const std::string& what_arg) : std::logic_error (what_arg) //_what(what_arg) //
      { }
    //    const char * what() const { return _what.c_str(); }
  };

  class matlabint_bad_arg : public matlabint_error {
  public:
    matlabint_bad_arg(const std::string& what) : matlabint_error(what) {}
      //    ~matlabint_bad_arg() throw() {} /* pourquoi g++-3.0 demande de definir cette fonction ? */
  };

  /* no callback for these exceptions */
#define THROW_ERROR(thestr) {                \
    std::stringstream msg;                   \
    msg << thestr << ends;                   \
    throw matlabint_error(msg.str());        \
  }
#define THROW_BADARG(thestr) {               \
    std::stringstream msg;                   \
    msg << thestr << ends;                   \
    throw matlabint_bad_arg(msg.str());      \
  }
  
}
#endif
