#include <matlabint.h>
#include <matlabint_pfi.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION gf_integ(method [, args..])
    General function for obtaining handle to various fem integrations methods

    * IM_EXACT_SIMPLEX(n)        : exact integration on simplexes.
    * IM_PRODUCT(a, b)           : product of two integration methods
    * IM_EXACT_PARALLELEPIPED(n) : exact integration on parallelepipeds
    * IM_EXACT_PRISM(n)          : exact integration on prisms
    * IM_GAUSS1D(K)       : Gauss method on the segment, order K
    * IM_NC(N,K)          : Newton-Cotes approximative integration 
    *                       on simplexes, order K
    * IM_NC_PARALLELEPIPED(N,K) :  product of Newton-Cotes integration 
    *                              on parallelepipeds
    * IM_NC_PRISM(N,K)    : product of Newton-Cotes integration on prisms
    * IM_GAUSS_PARALLELEPIPED(N,K) :  product of Gauss1D integration
    *                                 on parallelepipeds
    * IM_TRIANGLE(K)      : Gauss methods on triangles (K=1..7)
    * IM_QUAD(K)          : Gauss methods on quadrilaterons (K=2, 3 or 5)
    * IM_TETRAHEDRON(K)   : Gauss methods on tetrahedrons (K=1, 2, 3 or 5)

MLABCOM*/

void gf_integ(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(matlabint::ind_pfi(getfem::int_method_descriptor(cmd)),
			   INTEG_CLASS_ID);
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  catch_errors(nlhs, plhs, nrhs, prhs, gf_integ);
}
