#include <matlabint.h>
#include <matlabint_pgt.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION I = gf_geotrans(name)
    General function for building descriptors to geometric transformations.
    Name can be: 
    * 'GT_PK(N,K)'   : Transformation on simplexes, dim N, degree K
    * 'GT_QK(N,K)'   : Transformation on parallelepipeds, dim N, degree K
    * 'GT_PRISM(N,K)'          : Transformation on prisms, dim N, degree K
    * 'GT_PRODUCT(a,b)'        : tensorial product of two transformations
    * 'GT_LINEAR_PRODUCT(a,b)' : Linear tensorial product of two transformations
    
MLABCOM*/

void gf_geotrans(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(matlabint::ind_pgt(bgeot::geometric_trans_descriptor(cmd)),
			   GEOTRANS_CLASS_ID);
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  catch_errors(nlhs, plhs, nrhs, prhs, gf_geotrans);
}
