/* -*- c++ -*- (enables emacs c++ mode) */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_misc.h :                                            */
/*     									   */
/*                                                                         */
/* Date : December  2001.                                                  */
/* Author : J. Pommier, pommier@gmm.insa-tlse.fr                           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#ifndef __MATLAB_MISC_H
#define __MATLAB_MISC_H

#include "mex.h"
#include <matlabint.h>
#include <getfem_export.h>
namespace matlabint {

  

  mxArray * convert_to_mxSparse(const gf_sparse_matrix & smat);

  void build_edge_list(const getfem::getfem_mesh &m, getfem::edge_list &el, mexargs_in &in);

  /*
    interpolate the solution (in vector U) on the element cv, evaluated at the points 'pt'
  */
  template<class VECT> 
  void interpolate_on_convex_ref(getfem::mesh_fem *mf, getfem::size_type cv, 
				 const std::vector<getfem::base_node> &pt, 
				 const VECT& U, size_type U_dim, 
				 std::vector<getfem::scalar_type> &pt_val)
  {
    getfem::pfem cv_fem(mf->fem_of_element(cv)); assert(cv_fem != 0);

    /* largely inspired by getfem_export.h */

    /* interpolation of the solution.                                  */
    /* faux dans le cas des lments non tau-equivalents ou vectoriel. */
    assert(cv_fem->target_dim() == 1);
    assert(cv_fem->is_equivalent());
  
    getfem::base_matrix G;

    if (!(mf->fem_of_element(cv)->is_equivalent())) 
      getfem::transfert_to_G(G, mf->linked_mesh().points_of_convex(cv));

    for (size_type dim = 0; dim < U_dim; dim++) {
      getfem::base_vector coeff(mf->nb_dof_of_element(cv));
      for (getfem::size_type j = 0; j < coeff.size(); j++) {
	coeff[j] = U[mf->ind_dof_of_element(cv)[j]*U_dim + dim];
      }
  
      getfem::base_node val(1);
      pt_val.resize(pt.size());
      for (getfem::size_type j = 0; j < pt.size(); j++) {
	cv_fem->interpolation(pt[j], G, mf->linked_mesh().trans_of_convex(cv), coeff, val);
	pt_val[j*U_dim + dim] = val[0];
      }
    }
  }

};
#endif
