function [out1,out2,out3,out4,out5,out6,out7]=gf_stockes(p,e,t,b,viscos)
%[K,B,F,Q,G,H,R]=gf_stockes(p,e,t,b,viscos)
%[K1,B1,Fu,Fp,Permut,ud]=gf_stockes(p,e,t,b,viscos)
%[U,P]=gf_stockes(p,e,t,b,viscos)
  if nargin~=5,
    help gf_stockes;
    return;
  end;
  
  nodelst=new_intset;
  add_to_intset(nodelst,1,size(t,2));
  m=new_mesh;
  mesh_from_pdetool(m,p,t);
  mf_u=new_mesh_fem(m);
  fem_u=PK_with_cubic_bubble_fem(2,2);
  set_finite_element(mf_u,nodelst,fem_u, ...
			  gf_intmethod_exact_simplex(2));
  
  mf_p=new_mesh_fem(m);
  fem_p=PK_discontinuous_fem(2,1);
  set_finite_element(mf_p,nodelst,fem_p, ...
			  gf_intmethod_exact_simplex(2));
  
  
  xypts = gf_get_interpolation_pts(mf_u);
%  permut=sparse(size(p,2),size(p,2));
%  for i=1:size(p,2)
%    ii=find((xypts(1,i) == p(1,:)) & (xypts(2,i) == p(2,:)));
%    if (length(ii) ~= 1), keyboard; end;
%    permut((i-1)*2+1,ii)=1;
%    permut((i-1)*2+2,ii+size(p,2))=1;
%  end;

%  if nargout==1,
%    out1=permut;
%    return;
%  end
  
  mu = ones(gf_nb_dof(mf_p),1)*viscos;
  
  K = gf_assem_linear_elasticity(mf_u, mf_p, zeros(gf_nb_dof(mf_p),1), ...
			      mu);
  B = gf_assem_stockes_pressure_term(mf_u, mf_p, mf_p, mu);

  
  if (sum(sum(isnan(B)))),
    disp('et merdeuh B');
    spy(isnan(B)); keyboard;
  end;

%  m_B = size(B,1); n_B = size(B,2);
%  B(1:m_B,n_B+1) = ones(m_B,1);
%  B=B(:,1:(n_B-1));
  
  [Q,G,H,R]=gf_assemb(b,e,mf_u,mf_u);

  
  F=zeros(size(G)); % TODO... forces volumiques
  
  
  if (nargout==7),
    out1=K; out2=B; out3=F; out4=Q; out5=G; out6=H; out7=R;
    return;
  end;
  
  [null,orth]=pdenullorth(H);
  if size(orth,2)==0
    ud=zeros(size(K,2),1);
  else
    ud=full(orth*((H*orth)\R));
  end
  K=K+Q;
  if nnz(K-K')
    sym=0; disp('non symmectric matrix, aborting'); keyboard;
  else
    sym=1; disp('symmetric matrix, ok');
  end
  
    
  
  Fu=null'*((F+G)-K*ud);
  Fp = -B'*ud;
  K=null'*K*null;
  B=null'*B;
  if sym
    K=(K+K')/2;
  end

  if (nargout==6),
    out1=K; out2=B;out3=Fu;out4=Fp;out5=null;out6=ud;return;
  end;
  

  [UU,P]= gf_stockes_cgsolve(K,B,Fu,Fp);
  U=null*UU+ud;
  U=[U(1:2:length(U)) U(2:2:length(U))];
  
  if (nargout==4),
%    subplot(2,1,1); gf_pdeplot(mf_u,U(1:2:length(U))); colorbar;
%    subplot(2,1,2); gf_pdeplot(mf_u,U(2:2:length(U))); colorbar;
    out1=U;
    out2=mf_u;
    out3=P;
    out4=mf_p;
    return;
  end
  
  disp('invalid number of arguments');
