function h=gf_plot(mf,U,varargin)
% function h=gf_plot(mf,U,varargin)
% this function is used to plot a general pde solution
if nargin<2,
  error('Too few input arguments')
end

interpolated=0;
nrefine=8;
title='';
xyplot=1;
showmesh=0;
showboundary=0;
k=1;

cvlst=[];

while (k<=length(varargin))
  switch varargin{k}
   case 'xydata'
    xyplot=1; vectordata=0;
   case 'flowdata'
    xyplot=1; vectordata=1;
   case 'zdata'
    xyplot=0; vectordata=0;
   case 'refine'
    if (k<length(varargin)), nrefine=varargin{k+1}; k=k+1;
    else, error('missing value for "refine" argument'); 
    end
   case 'interpolated'
    interpolated=1;
   case 'mesh'
    showmesh=1;
   case 'boundaries'
    showboundary=1;
   case 'cvlst'
    if (k<length(varargin)), cvlst=varargin{k+1}; k=k+1;
    else, error('missing value for "cvlst" argument'); 
    end
   otherwise
    error(['Unknown parameter: ' varargin{k}]);
  end
  k=k+1;
end

is_hold = ishold;

if (cvlst == []), cvlst = gf_mesh_get(mf,'cvid'); end;

if (size(U,1) == 1), vectordata=0;
elseif (size(U,1) == 2), vectordata=1;
else error(['U should have 1 row (scalar data) or 2 rows (vector data)']); end;

nbdof=gf_mesh_fem_get(mf,'nbdof');
if (nbdof <= 0), error('invalid finite element mf argument'); end

if (size(U,2) ~= nbdof),
  error(['wrong dimensions for U, should' ...
	 ' have ' int2str(nbdof) 'columns']); 
end

% interpolate the solution on a refined P1 mesh
if (vectordata == 0),
  P = gf_compute(mf, U, 'eval on refined P1 tri mesh', nrefine, cvlst);
end;

ax = newplot;
if (xyplot), view(2); else view(3); end;


if (showmesh), hold on; 
  if (showboundary)
    gf_plot_mesh(mf, 'boundaries'); 
  else
    gf_plot_mesh(mf);
  end;
end;


if (vectordata==0),
  if (interpolated==0),
    V=mean(P(7:9,:));
  else
    V=P(7:9,:);
  end

  if (xyplot),
    hh=patch(P(1:2:6,:),P(2:2:6,:), V, 'Parent', ax, 'Erasemode','normal','Edgecolor','none');
  else
    hh=patch(P(1:2:6,:),P(2:2:6,:), V, V, 'Parent', ax, 'Erasemode','normal','Edgecolor','none');
  end;
else
  xy=gf_mesh_fem_get(mf, 'dofs nodes');
  ptlst=find(~isnan(xy(1,:)));
  bmin = min(xy); bmax = max(xy);
  xyscale = max(bmax-bmin);
  vscale  = max(max(abs(U)));
  while (numel(ptlst)>0)
    ii = ptlst(1); 
    x = xy(1,ii); y = xy(2, ii);
    rm = (find((xy(1,:)-x).^2 + (xy(2,:)-y).^2 < (xyscale/50)^2));
    if (numel(rm)==0) error('internal error in gf_plot'); end;
    ptlst = setdiff(ptlst, rm);
%    disp(sprintf('x=%f y=%f reste %d',x,y,numel(ptlst)));
   
    h=line([x x+U(1,ii)*(xyscale/10/vscale)],...
	   [y y+U(2,ii)*(xyscale/10/vscale)]);
    set(h,'Color', [1. .4 0]);
    set(h,'LineWidth', 2);
  end;
end

if (is_hold)
  hold on;
else
  hold off;
end;