#include <matlabint_misc.h>
#include <matlabint_workspace.h>
#include <matlabint_mesh_fem.h>
#include <matlabint_mesh.h>

using namespace matlabint;

/*MLABCOM
  FUNCTION I = gf_mesh_fem(mesh M [, int u_dim=1])

  General constructor for mesh_fem object. Returns a getfem handle 
  to the newly created mesh_fem object.

  $Id: gf_mesh_fem.C,v 1.4 2002/09/02 09:29:58 pommier Exp $
MLABCOM*/

void gf_mesh_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1 || in.narg() > 2) {
    DAL_THROW(matlabint_bad_arg, "Wrong number of input arguments");
  } else if (out.narg() != 1) {
    DAL_THROW(matlabint_bad_arg, "Wrong number of output arguments");
  } else {
    matlabint_mesh *mm = in.pop().to_matlabint_mesh();
    unsigned u_dim            = 1;
    if (in.remaining()) u_dim = in.pop().to_integer(0,256);
    matlabint_mesh_fem *mmf = new matlabint_mesh_fem(&mm->mesh(),u_dim);
    out.pop().from_object_id(workspace().push_object(mmf));
    workspace().set_dependance(mmf, mm);
  }
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  catch_errors(nlhs, plhs, nrhs, prhs, gf_mesh_fem, "gf_mesh_fem");
}
