#include <matlabint_misc.h>
#include <matlabint_pfem.h>

using namespace matlabint;
/*MLABCOM
  FUNCTION gf_fem(fem_name [, fem_arg..])
    Returns a handle to one of the various Finite Elements Method defined
    in Getfem. The fem_name can be one of these:

    * gf_fem('PK', dim, k) : classical PK fem on a simplex of dimension 
    DIM.

    * gf_fem('QK', dim, k) : classical QK fem.

    * gf_fem('PK discontinuous') : PK fem with discontinous data.

    * gf_fem('PK cubic bubble') : PK finite element on which a bubble base function
    has been added (hence it is no more a lagrange finite element). Often called
    PK+ fem.

    * gf_fem('product', fem F1, fem F2) : 

MLABCOM*/

void gf_fem(matlabint::mexargs_in& in, matlabint::mexargs_out& out)
{
  if (in.narg() < 1) {
    DAL_THROW(matlabint_bad_arg, "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(matlabint::ind_pfem(getfem::fem_descriptor(cmd))
			   + MATLABINT_PFEM_MASK);
}
/*  


  if (check_cmd(cmd, "PK", in, out, 2, 2, 0, 1)) {
    unsigned dim = in.pop().to_integer(0,256);
    unsigned k   = in.pop().to_integer(0,256);
    out.pop().from_object_id(matlabint::ind_pfem(getfem::PK_fem(dim, k))
			     + MATLABINT_PFEM_MASK);

  } else if (check_cmd(cmd, "QK", in, out, 2, 2, 0, 1)) {
    unsigned dim = in.pop().to_integer(0,256);
    unsigned k   = in.pop().to_integer(0,256);
    out.pop().from_object_id(matlabint::ind_pfem(getfem::QK_fem(dim, k))
			     + MATLABINT_PFEM_MASK);    
  } else if (check_cmd(cmd, "PK discontinuous", in, out, 2, 2, 0, 1)) {
    unsigned dim = in.pop().to_integer(0,256);
    unsigned k   = in.pop().to_integer(0,256);
    out.pop().from_object_id(matlabint::ind_pfem(getfem::PK_discontinuous_fem(dim, k))
			     + MATLABINT_PFEM_MASK);    
  } else if (check_cmd(cmd, "PK discontinous", in, out, 2, 2, 0, 1)) {
    unsigned dim = in.pop().to_integer(0,256);
    unsigned k   = in.pop().to_integer(0,256);
    out.pop().from_object_id(matlabint::ind_pfem(getfem::PK_with_cubic_bubble_fem(dim, k))
			     + MATLABINT_PFEM_MASK);    
  } else if (check_cmd(cmd, "product", in, out, 2, 2, 0, 1)) {
    getfem::pfem pf1 = in.pop().to_fem();
    getfem::pfem pf2 = in.pop().to_fem();
    if (!pf1->is_polynomial() || !pf1->is_polynomial())
      DAL_THROW(matlabint_error, "Impossible to build the product of non polynomial fems.");
    out.pop().from_object_id(matlabint::ind_pfem(getfem::product_fem(getfem::ppolyfem(pf1), 
								     getfem::ppolyfem(pf2))) 
			     + MATLABINT_PFEM_MASK);
  } else bad_cmd(cmd);
}
*/

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  catch_errors(nlhs, plhs, nrhs, prhs, gf_fem);
}
