/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_poly.C : polynomials management.                    */
/*     									   */
/*                                                                         */
/* Date : October 10, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <matlabint_poly.h>
#include <dal_tas.h>

namespace matlabint
{
  static dal::dynamic_tas< bgeot::base_poly > *poly_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      poly_tab = new dal::dynamic_tas< bgeot::base_poly >();
    }
  }

  int new_poly(void)
  { init_tab(); return poly_tab->add(bgeot::base_poly()); }

  void del_poly(int i)
  { init_tab(); (*poly_tab)[i].clear(); poly_tab->sup(i); }

  bgeot::base_poly &poly(int i)
  { init_tab(); return (*poly_tab)[i]; }

  bool exists_poly(int i)
  { init_tab(); return poly_tab->index()[i]; }

  void clear_all_poly(void)
  { init_tab(); (*poly_tab).clear(); }

}  /* end of namespace matlabint.                                          */
