/* -*- c++ -*- (enables emacs c++ mode) */
/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_misc.h :                                            */
/*     									   */
/*                                                                         */
/* Date : December  2001.                                                  */
/* Author : J. Pommier, pommier@gmm.insa-tlse.fr                           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#ifndef __MATLAB_MISC_H
#define __MATLAB_MISC_H

#include "mex.h"
#include <getfem_assembling.h>
#include <bgeot_smatrix.h>
#include <matlabint.h>

#ifdef NDEBUG
#error "merci de virer le -DNDEBUG , pour avoir des assertions qui marchent"
#endif
/*
#ifdef assert
#undef assert
#endif 

#define assert(x) { if (!(x)) { mexPrintf("failed assertion, file " __FILE__ ", line %d\n", __LINE__); abort(); } }
*/


class VECbidon {
public:
  double *ve;
  double &operator[](int idx) { return ve[idx]; }
  double operator[](int idx) const { return ve[idx]; }
  VECbidon(double *v) { ve = v; }
  VECbidon() { ve = NULL; }
};

mxArray * convert_to_mxSparse(bgeot::smatrix<getfem::scalar_type> & smat);
getfem::mesh_fem * check_for_mesh_fem_arg(const mxArray *arg);
const getfem::getfem_mesh *check_for_const_mesh_arg(const mxArray *arg);
getfem::getfem_mesh *check_for_mesh_arg(const mxArray *arg);
getfem::pintegration_method check_for_fem_interpolation_arg(const mxArray *arg);
double *check_for_node_values(const mxArray *arg, getfem::mesh_fem *mf, 
			      getfem::size_type dim = 1, getfem::size_type* p_outdim = 0);
int check_for_scalar_integer_arg(const mxArray *arg, int arg_num, const char *arg_name);
void interpolate_on_convex_ref(getfem::mesh_fem *mf, getfem::size_type cv, 
			       const std::vector<getfem::base_node> &pt, 
			       double *U,
			       std::vector<getfem::scalar_type> &val);
#endif
