#include <matlabint_mesh_fem.h>
#include <matlabint_mesh.h>
#include <matlabint_pfi.h>
#include <matlabint_misc.h>

#define IS_ZERO(x) (fabs(x)<1e-14)

//int    finite     (double x);

mxArray *
convert_to_mxSparse(bgeot::smatrix<bgeot::scalar_type> & smat)
{
  //  matlabint::smatrix<double>::const_iterator smat_i;
  
  int ni = smat.nrows();
  int nj = smat.ncols();
  int nnz = 0;
  int i;
  
  std::vector<int> ccnt(nj);
  
  mxArray *mxA;
  
  mexPrintf("ni=%d, nj=%d\n", ni, nj);
  
  std::fill(ccnt.begin(), ccnt.end(), 0);
  /* comptage du nb d'lements non nuls pour chaque colonne */
  // NE MARCHE PAS GRRRRRRR  for (smat_i=smat.begin(); smat_i != smat.end(); smat_i++) {
  for (i = 0; i < ni; i++) {
    //mexPrintf("ligne[%d]: size=%d\n", i, smat[i].size());
    bgeot::smatrix<bgeot::scalar_type>::_line_m::const_sorted_iterator p;
    for (p = smat[i].sorted_begin(); p != smat[i].sorted_end(); p++) {
#     ifdef __GETFEM_VERIFY
      //      assert((*p) <= smat->size());
#     endif
      if (!IS_ZERO((*p).val)) {
	/*
	if (!::finite((*p).e)) {
	  mexPrintf("oups: [%d:%d] = %f", i, (*p).c, (*p).e);
	}
	*/
	//mexPrintf(" ***");
	ccnt[(*p).rang]++;
	nnz++;
      }
      //      mexPrintf("\n");
    }
  }

  mexPrintf("nnz = %d\n", nnz);
  

  /* rservation mmoire pour matlab */
  mxA = mxCreateSparse(ni, nj, nnz, mxREAL); assert(mxA != NULL);
  
  double *pr;
  int *ir, *jc;
  pr = mxGetPr(mxA); assert(pr != NULL);
  ir = mxGetIr(mxA); assert(ir != NULL);
  jc = mxGetJc(mxA); assert(jc != NULL); /* dim == nj+1 */
  
  int j;

  jc[0] = 0;
  for (j=0; j < nj; j++) {
    //    mexPrintf("ccnt[%d]=%d\n", j, ccnt[j]);
    jc[j+1] = jc[j] + ccnt[j];
  }
  assert(nnz == jc[nj]);

  /* remplissage de pr et ir */
  std::fill(ccnt.begin(), ccnt.end(), 0);
  for (i=0; i < ni; i++) {
    bgeot::smatrix<bgeot::scalar_type>::_line_m::const_iterator p;
    for (p = smat[i].begin(); p != smat[i].end(); p++) {
      if (!IS_ZERO((*p).val)) {
	ir[jc[(*p).rang]+ccnt[(*p).rang]] = i;
	pr[jc[(*p).rang]+ccnt[(*p).rang]] = (*p).val;
	ccnt[(*p).rang]++;
      }
    }
  }
  
  return mxA;
}




/*
  check if the argument is a valid handle to a mesh_fem,
  and returns it
*/
getfem::mesh_fem *
check_for_mesh_fem_arg(const mxArray *arg)
{

  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(arg));
  if (mxGetClassID(arg) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_MESHFEM_MASK)
    mexErrMsgTxt("argument should be a mesh_fem descriptor");
  if (!matlabint::exists_mesh_fem(*p - MATLABINT_MESHFEM_MASK))
    mexErrMsgTxt("This mesh_fem no longer exists");
  
  return &(matlabint::mesh_fem(*p - MATLABINT_MESHFEM_MASK));
}

/*
  check if the argument is a valid mesh handle
  if a mesh_fem handle is given, its associated
  mesh is used
*/
const getfem::getfem_mesh *
check_for_const_mesh_arg(const mxArray *arg)
{
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(arg));

  /* check for mesh descriptor */
  if (mxGetClassID(arg) == mxUINT32_CLASS 
      && (*p & 0xFF000000) == MATLABINT_MESH_MASK) {
    int i = *p - MATLABINT_MESH_MASK;
    if (!matlabint::exists_mesh(i))
      mexErrMsgTxt("This mesh no longer exists.");
    return &(matlabint::mesh(i));
    
    /* check for mesh_fem descriptor */
  } else if (mxGetClassID(arg) == mxUINT32_CLASS 
	     && (*p & 0xFF000000) == MATLABINT_MESHFEM_MASK) {
    int i = *p - MATLABINT_MESHFEM_MASK;
    if (!matlabint::exists_mesh_fem(i))
      mexErrMsgTxt("This mesh_fem no longer exists");
    return &((matlabint::mesh_fem(i)).linked_mesh());
  } else {
    mexErrMsgTxt("Input argument should be a descriptor returned by new_mesh, or a mesh_fem descriptor");
  } 
  return NULL;
}

/*
  check if the argument is a valid mesh handle

  (the returned arg is not const, so we can't use the mesh from mesh_fem objects)
*/
getfem::getfem_mesh *
check_for_mesh_arg(const mxArray *arg)
{
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(arg));

  /* check for mesh descriptor */
  if (mxGetClassID(arg) == mxUINT32_CLASS 
      && (*p & 0xFF000000) == MATLABINT_MESH_MASK) {
    int i = *p - MATLABINT_MESH_MASK;
    if (!matlabint::exists_mesh(i))
      mexErrMsgTxt("This mesh no longer exists.");
    return &(matlabint::mesh(i));
    
    /* check for mesh_fem descriptor */
  } else {
    mexErrMsgTxt("Input argument should be a descriptor returned by new_mesh, or a mesh_fem descriptor");
  }
  return NULL;
}

getfem::pintegration_method
check_for_fem_interpolation_arg(const mxArray *arg)
{
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(arg));
  if (mxGetClassID(arg) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_PFI_MASK)
    mexErrMsgTxt("argument should be a integration method descriptor.");
  dal::uint32_type i = *p - MATLABINT_PFI_MASK;
  if (!matlabint::exists_pfi(i))
    mexErrMsgTxt("This integration method does not exist.");
  return matlabint::addr_pfi(i);
}


/* check that the argument has a good type and size
   for containing one value per node 

   argument dim is used for data with vector values on each dof
   on input: dim == 0  : data with an arbitrary number of values/dof is accepted
             dim >= 1  : only 'dim' values/node accepted, the matrix should have 'dim' rows and 'nb_dof' columns
	     (default : dim = 1, p_outdim = NULL)
   on ouput: p_outdim contains the number of rows
*/
double *
check_for_node_values(const mxArray *arg, getfem::mesh_fem *mf, getfem::size_type dim, getfem::size_type* p_outdim)
{
  getfem::size_type n, m, len = 0, out_dim;

  if(!(mxIsDouble(arg))) {
    mexErrMsgTxt("argument must be of type double.");
  }

  m=mxGetM(arg); n=mxGetN(arg); 

  if (m == 1 || n == 1) {
    out_dim = 1; len = (m == 1) ? n : m;
    if (len > mf->nb_dof() && (len % mf->nb_dof() == 0)) {
      out_dim = len / mf->nb_dof();
      len = mf->nb_dof();
    }
  } else {
    out_dim = m;
    len = n;
  }

  if (len != mf->nb_dof()) {
    mexPrintf("Size of argument (%d) should be the number of degree of freedom of the mesh_fem (%u)\n", len, mf->nb_dof());
    if (m == mf->nb_dof()) {
      mexPrintf("you should probably transpose the supplied matrix\n");
    }
    mexErrMsgTxt("sorry");
  }

  if (dim != out_dim && dim != 0) {
    mexPrintf("The supplied argument is supposed to have %d rows", dim); mexErrMsgTxt("sorry");
  }
  if (p_outdim) *p_outdim = out_dim;

  return mxGetPr(arg);
}

int
check_for_scalar_integer_arg(const mxArray *arg, int arg_num, const char *arg_name) {
  double dv;
  
  if (mxGetM(arg) != 1 || mxGetN(arg) != 1) {
    mexPrintf("bad value for argument %d (%s), whose dimensions are %dx%d\n", arg_num, arg_name, 
	      mxGetN(arg),mxGetM(arg));
    mexErrMsgTxt("scalar expected");
  }
  switch (mxGetClassID(arg)) {
  case mxDOUBLE_CLASS: {
    dv = *mxGetPr(arg);
  } break;
  case mxSINGLE_CLASS: {
    dv = (double)( *((float*)mxGetData(arg)));
  } break;
  case mxINT32_CLASS: {
    dv = (double)( *((dal::int32_type*)mxGetData(arg)));
  } break;
  case mxUINT32_CLASS: {
    dv = (double)( *((dal::uint32_type*)mxGetData(arg)));
  } break;
  case mxINT16_CLASS: {
    dv = (double)( *((dal::int16_type*)mxGetData(arg)));
  } break;
  case mxUINT16_CLASS: {
    dv = (double)( *((dal::uint16_type*)mxGetData(arg)));
  } break;
  default: {
    mexPrintf("expecting an integer value");
  } break;
  }

  if (dv != floor(dv)) {
    mexPrintf("expecting an integer value");
  }
  return (int)dv;
}

/*
  interpolate the solution (in vector U) on the element cv, evaluated at the points 'pt'
*/
void
interpolate_on_convex_ref(getfem::mesh_fem *mf, getfem::size_type cv, 
			  const std::vector<getfem::base_node> &pt, 
			  double *U,
			  std::vector<getfem::scalar_type> &pt_val)
{
  getfem::pfem cv_fem(mf->fem_of_element(cv)); assert(cv_fem != 0);

  /* largely inspired by getfem_export.h */

  /* interpolation of the solution.                                  */
  /* faux dans le cas des lments non tau-equivalents ou vectoriel. */
  assert(cv_fem->target_dim() == 1);
  assert(cv_fem->is_equivalent());
  
  getfem::base_vector coeff(mf->nb_dof_of_element(cv));
  for (getfem::size_type j = 0; j < coeff.size(); j++) {
    coeff[j] = U[mf->ind_dof_of_element(cv)[j]];
  }
  
  getfem::base_matrix G;
  getfem::base_node val(1);

  pt_val.resize(pt.size());
  for (getfem::size_type j = 0; j < pt.size(); j++) {
    cv_fem->interpolation(pt[j], G, coeff, val);
    pt_val[j] = val[0];
  }
}
