/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh_fem.C : mesh fem management.                   */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABINT_MESH_FEM_H
#define __MATLABINT_MESH_FEM_H

#include <matlabint.h>
#include <getfem_mesh_fem.h>

namespace matlabint
{
  int new_mesh_fem(getfem::getfem_mesh &);
  void del_mesh_fem(int i);
  getfem::mesh_fem &mesh_fem(int i);
  bool exists_mesh_fem(int i);
  void clear_all_mesh_fem(void);
  void clear_all_mesh_fem(const getfem::getfem_mesh &);
  
}  /* end of namespace matlabint.                                          */

#endif /* __MATLABINT_MESH_FEM_H                                           */
