/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh_fem.h : mesh fem management.                   */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <matlabint_mesh_fem.h>

namespace matlabint
{
  static dal::dynamic_tas<getfem::mesh_fem *> *mesh_fem_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      mesh_fem_tab = new dal::dynamic_tas<getfem::mesh_fem *>();
    }
  }

  int new_mesh_fem(getfem::getfem_mesh &m)
  {
    init_tab(); return mesh_fem_tab->add(new getfem::mesh_fem(m));
  }

  void del_mesh_fem(int i)
  {
    init_tab(); delete (*mesh_fem_tab)[i]; mesh_fem_tab->sup(i);
  }

  getfem::mesh_fem  &mesh_fem(int i)
  { init_tab(); return *((*mesh_fem_tab)[i]); }

  bool exists_mesh_fem(int i)
  { init_tab(); return mesh_fem_tab->index()[i]; }

  void clear_all_mesh_fem(void)
  { 
    init_tab(); 
    dal::bit_vector nn = mesh_fem_tab->index();
    getfem::size_type i;
    for (i << nn; i != getfem::size_type(-1); i << nn)
      delete (*mesh_fem_tab)[i];
    (*mesh_fem_tab).clear();
  }

  void clear_all_mesh_fem(const getfem::getfem_mesh &m)
  {
    init_tab(); 
    dal::bit_vector nn = mesh_fem_tab->index();
    getfem::size_type i;
    for (i << nn; i != getfem::size_type(-1); i << nn)
      if (&(((*mesh_fem_tab)[i])->linked_mesh()) == &m) del_mesh_fem(i);
  }

  void just_for_cxx_link_03502(void)
  {   // Necessary for cxx compiler on DEC ...
    getfem::mesh_fem *pmf = NULL;
    getfem::pmat_elem_type pmet = NULL;
    getfem::base_tensor t;
    std::vector<int> tab(t.order());
    std::copy(t.sizes().begin(), t.sizes().end(), tab.begin());
    // pmf->mat_elem(pmet, t, 4);
    // pmf->mat_elem_on_face(pmet, t, 4, 2);
    double *q = NULL;
    std::copy(t.begin(), t.end(), q);	
  }

}  /* end of namespace matlabint.                                          */
