/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_mesh.h : mesh management.                           */
/*     									   */
/*                                                                         */
/* Date : September 25, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <matlabint_mesh.h>
#include <matlabint_mesh_fem.h>

namespace matlabint
{
  static dal::dynamic_tas<getfem::getfem_mesh> *mesh_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      mesh_tab = new dal::dynamic_tas<getfem::getfem_mesh>();
    }
  }

  int new_mesh(void)
  {
    init_tab(); return mesh_tab->add(getfem::getfem_mesh());
  }

  void del_mesh(int i)
  {
    init_tab(); clear_all_mesh_fem((*mesh_tab)[i]);
    (*mesh_tab)[i].clear(); mesh_tab->sup(i); 
  }

  getfem::getfem_mesh  &mesh(int i)
  { init_tab(); return (*mesh_tab)[i]; }

  bool exists_mesh(int i)
  { init_tab(); return mesh_tab->index()[i]; }

  void clear_all_mesh(void)
  { init_tab(); (*mesh_tab).clear(); }
}  /* end of namespace matlabint.                                          */
