/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint) version 1.0                      */
/* File    : matlabint_intset.h : intset management.                       */
/*     									   */
/*                                                                         */
/* Date : September 25, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABINT_MESH_H
#define __MATLABINT_MESH_H

#include <matlabint.h>
#include <dal_bit_vector.h>
#include <dal_tas.h>

namespace matlabint
{
  int new_intset(void);
  void del_intset(int i);
  dal::bit_vector &intset(int i);
  bool exists_intset(int i);
  void clear_all_intset(void);
  
}  /* end of namespace matlabint.                                          */

#endif /* __MATLABINT_MESH_H                                               */
