/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint_intset.C : intset management.                       */
/*     									   */
/*                                                                         */
/* Date : September 26, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <matlabint_intset.h>

namespace matlabint
{
  static dal::dynamic_tas< dal::bit_vector > *intset_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      intset_tab = new dal::dynamic_tas< dal::bit_vector >();
    }
  }

  int new_intset(void)
  { init_tab(); return intset_tab->add(dal::bit_vector()); }

  void del_intset(int i)
  { init_tab(); (*intset_tab)[i].clear(); intset_tab->sup(i); }

  dal::bit_vector &intset(int i)
  { init_tab(); return (*intset_tab)[i]; }

  bool exists_intset(int i)
  { init_tab(); return intset_tab->index()[i]; }

  void clear_all_intset(void)
  { init_tab(); (*intset_tab).clear(); }

}  /* end of namespace matlabint.                                          */
