/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Interface (matlabint)                                  */
/* File    : matlabint.h : global definitions for Matlab interface.        */
/*     									   */
/*                                                                         */
/* Date : September 26, 2001.                                              */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABINT_H
#define __MATLABINT_H

#include "mex.h"
#include <dal_std.h>

namespace matlabint
{
  typedef size_t size_type;
  typedef dal::uint32_type id_type;

  #define MATLABINT_MESH_MASK        0x10000000
  #define MATLABINT_INTSET_MASK      0x11000000
  #define MATLABINT_CVS_MASK         0x12000000
  #define MATLABINT_POLY_MASK        0x13000000
  #define MATLABINT_PGT_MASK         0x14000000
  #define MATLABINT_PFI_MASK         0x15000000
  #define MATLABINT_PFEM_MASK        0x16000000
  #define MATLABINT_MATELEMTYPE_MASK 0x17000000
  #define MATLABINT_MATELEM_MASK     0x18000000
  #define MATLABINT_MESHFEM_MASK     0x19000000

  #define mexint_test_narg(i, j, k, h) \
  { \
    if (nrhs < i || nrhs > j) \
      mexErrMsgTxt("Wrong number of input arguments."); \
    if (nlhs < k || nlhs > h) \
      mexErrMsgTxt("Wrong number of output arguments."); \
  }

  typedef void (*mex_func_type)(int, mxArray **, int, const mxArray **);
  void catch_errors(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[],
		    mex_func_type pf);
}  /* end of namespace matlabint.                                          */

#endif /* __MATLABINT_H                                                    */
