/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : print_poly.C : print to screen a polynomial variable.         */
/*     									   */
/*                                                                         */
/* Date : October 10, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_poly.h>

/**@name print_poly(i)
 * Print to screen a polynomial variable. i should be a descriptor given
 * by new_poly.
 */
//@{
//@}


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 1)
    mexErrMsgTxt("Wrong number of input arguments, should be 1.");
  if (nlhs != 0)
    mexErrMsgTxt("No output argument needed.");
  matlabint::id_type *p = (matlabint::id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_POLY_MASK)
    mexErrMsgTxt("Input argument should be a descriptor returned by new_poly.");
  int i = *p - MATLABINT_POLY_MASK;
  if (!matlabint::exists_poly(i))
    mexErrMsgTxt("This polynomial no longer exists.");

  
  bgeot::base_poly *pp = &(matlabint::poly(i));
  bool first = true; bgeot::size_type n = 0;
  bgeot::base_poly::const_iterator it = pp->begin(), ite = pp->end();
  bgeot::power_index mi(pp->dim());

  if (it != ite && *it != 0.0)
  { mexPrintf("%g", double(*it)); first = false; ++it; ++n; ++mi; }

  for ( ; it != ite ; ++it, ++mi )
  {
    if (*it != 0.0)
    {
      if (!first) { if (*it < 0.0) mexPrintf(" - "); else mexPrintf(" + "); }
      else if (*it < 0.0) mexPrintf("-");
      if (dal::abs(*it) != 1.0) mexPrintf("%g", double(dal::abs(*it)));
      for (int j = 0; j < pp->dim(); ++j)
	if (mi[j] != 0)
	{ 
	  mexPrintf("%c", (j < 3) ? char(int('x')+ j) : char(int('x')+2-j));
	  if (mi[j]>1) mexPrintf("^%d", int(mi[j]));
	}
      first = false; ++n;
    }
  }
  if (n == 0) mexPrintf("0");
 
}
