/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : new_poly.C : create a new polynomial variable.                */
/*     									   */
/*                                                                         */
/* Date : October 10, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_poly.h>

/**@name i = new_poly
 * create a new polynomial variable and return in i the identifier. i is
 * a 32 bits integer. Be carrefull, once a polynomial is created, it is stored
 * in memory and it is not destroyed by the clear command of Matlab.
 * Destroy it with the commands del_poly or clear_all_poly
 */
//@{
//@}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 0) {
    mexErrMsgTxt("No Input arguments needed.");
  } else if (nlhs != 1) {
    mexErrMsgTxt("Must have one output argument.");
  }
 
  matlabint::id_type i = matlabint::new_poly() + MATLABINT_POLY_MASK;
  int j = 1;
  plhs[0] = mxCreateNumericArray(1, &j, mxUINT32_CLASS, mxREAL);
  *((matlabint::id_type *)(mxGetData(plhs[0]))) = i;
 
}
