/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : new_mesh_fem.C : create a new mesh fem variable.              */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_mesh.h>
#include <matlabint_mesh_fem.h>

/**@name i = new_mesh_fem(me)
 * create a new mesh fem variable associated with mesh me and return in
 * i the identifier. i is
 * a 32 bits integer. Be carrefull, once a mesh fem is created, it is stored
 * in memory and it is not destroyed by the clear command of Matlab.
 * Destroy it with the commands del_mesh_fem or clear_all_mesh_fem
 */
//@{
//@}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 1) {
    mexErrMsgTxt("One Input argument needed.");
  } else if (nlhs != 1) {
    mexErrMsgTxt("Must have one output argument.");
  }

  matlabint::id_type *p1 = (matlabint::id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p1 & 0xFF000000) != MATLABINT_MESH_MASK)
    mexErrMsgTxt("First input argument should be a mesh descriptor");
  matlabint::id_type a = *p1 - MATLABINT_MESH_MASK;
  if (!matlabint::exists_mesh(a))
    mexErrMsgTxt("Mesh corresponding to first argument does not exist.");

  dal::uint32_type i = matlabint::new_mesh_fem(matlabint::mesh(a)) + MATLABINT_MESHFEM_MASK;
  int j = 1;
  plhs[0] = mxCreateNumericArray(1, &j, mxUINT32_CLASS, mxREAL);
  *((dal::uint32_type *)(mxGetData(plhs[0]))) = i;
 
}
