/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : mesh_transformation.C : deformation of  a mesh.               */
/*     									   */
/*                                                                         */
/* Date : October 12, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <matlabint_mesh.h>

/**@name mesh_transformation(i, M)
 * Transforms the mesh i applying matrix M to each point.
 */
//@{
//@}

#define id_type matlabint::id_type

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  mexint_test_narg(2, 2, 0, 0);
  
  id_type *p = (id_type *)(mxGetData(prhs[0]));
  if (mxGetClassID(prhs[0]) != mxUINT32_CLASS 
      || (*p & 0xFF000000) != MATLABINT_MESH_MASK)
    mexErrMsgTxt("First input argument should be a descriptor returned by new_mesh.");
  int i1 = *p - MATLABINT_MESH_MASK;
  if (!matlabint::exists_mesh(i1))
    mexErrMsgTxt("First mesh no longer exists.");
  getfem::getfem_mesh *pmesh = &(matlabint::mesh(i1));

  
  float *q = (float *)(mxGetData(prhs[1]));
  if (mxGetN(prhs[1]) != mxGetM(prhs[1]))
    mexErrMsgTxt("Works only with a square matrix.");
  int nc = mxGetN(prhs[1]);
    
  if (pmesh->dim() != nc || nc <= 0)
    mexErrMsgTxt("Incorrect matrix dimension.");

  bgeot::base_matrix M(nc, nc);
  double *pm = &(M.begin()[0]);
  for (int j = 0; j < nc*nc; ++j, ++q, ++pm)
  {
    switch (mxGetClassID(prhs[1]))
    {
      case mxDOUBLE_CLASS : *pm = (*((double *)q)); ++q;   break;
      case mxSINGLE_CLASS : *pm = (double)(*((float *)q)); break;
      default : mexErrMsgTxt("Incorrect arguments.");
    }
  }

  pmesh->transformation(M);
  
}
