/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : mesh_to_edges.C : list all edges of a mesh.                   */
/*     									   */
/*                                                                         */
/* Date : October 15, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */

#include "mex.h"
#include <getfem_export.h>
#include <matlabint_misc.h>

/**@name M = mesh_to_edges(i)
 * return a 32 bits integer matrix M containing all edges of mesh identified
 * by i (i might be a mesh_fem descriptor)
 */
//@{
//@}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  if (nrhs != 1)
    mexErrMsgTxt("Wrong number of input arguments, should be 1.");
  else if (nlhs > 1)
    mexErrMsgTxt("Must have one output argument.");
  
  const getfem::getfem_mesh *pmesh = check_for_const_mesh_arg(prhs[0]);
  
  getfem::edge_list el;
  getfem::mesh_edges_list(*pmesh, el);

  int j[2]; j[1] = el.index().card(); j[0] = 2;
  plhs[0] = mxCreateNumericArray(2, j, mxUINT32_CLASS, mxREAL);
  matlabint::id_type *q = (matlabint::id_type *)(mxGetData(plhs[0]));
  
  for (int k = 0; k < j[1]; ++k) { *q++ = (el[k].i + 1);  *q++=(el[k].j + 1);}
 
}
