/* *********************************************************************** */
/*                                                                         */
/* Library : Matlab Command (matlabcom)                                    */
/* File    : intro_doc.h : Doc++ documentation of matlabcom.               */
/*                                                                         */
/* Date : October 9, 2001.                                                 */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef __MATLABCOM_H
#define __MATLABCOM_H


/**@name Getting Started
 * blabla
 */
//@{
//@}

/**@name What is Getfem
 * blabla
 */
//@{
//@}

/**@name How to use this manual
 * blabla
 */
//@{
//@}


/**@name Quick Start
 * blabla
 */
//@{
//@}

/**@name High level commands
 * blabla
 */
//@{
//@}

/**@name Intermediary commands
 * blabla
 */
//@{
//@}

/**@name Low level commands
 * The low level commands guide list all the commands of GETFEM, packages
 * by packages.
 */
//@{
/* *********************************************************************** */
/*                                                                         */
/*   intset commands                                                       */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Intsets
   * An intset is a variable which represents a set of non-negative integers.
   * The representation of this variable is a bit array. \\ \\
   * Exemple : \\
   * >> i = new_intset;  \\
   * >> add_to_intset(i, 1, 100); \\
   * >> sup_to_intset(i, 5, 95); \\
   * >> list_intset(i)\\ \\
   * ans = \\ \\
   *   1 \\
   *   2 \\
   *   3 \\
   *   4 \\
   *  96 \\
   *  97 \\
   *  98 \\
   *  99 \\
   * 100 \\ \\
   * >> del_intset(i); \\
   */
  //@{
    //@Include: new_intset.C
    //@Include: del_intset.C
    //@Include: clear_all_intset.C
    //@Include: add_to_intset.C
    //@Include: sup_to_intset.C
    //@Include: list_intset.C
  //@} 

/* *********************************************************************** */
/*                                                                         */
/*  polynomials commands                                                   */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on multi-variables Polynomials
   * A multi-variables polynomial is a variable which represents a polynomial
   * of a fixed degree and a fixed number of variables.
   * The representation of this variable is a plain vector of coefficient.
   * See GETFEM++ documentation for more information about algorithm on
   * such olynomials \\ \\
   * Exemple : \\
   * >> i = new_poly;  \\
   * >> del_intset(i); \\
   */
  //@{
    //@Include: new_poly.C
    //@Include: del_poly.C
    //@Include: set_poly.C
    //@Include: mul_poly.C
    //@Include: add_poly.C
    //@Include: clear_all_poly.C
  //@} 

/* *********************************************************************** */
/*                                                                         */
/*  convex structures commands                                             */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Convex Structures
   * A convex structures represent the structure of a convex without its
   * vertex. Basic convex structures are simplexes and direct product of
   * simplexes.
   * Exemple : \\
   * >> i = simplex_structure(2); \\
   * >> j = simplex_structure(1); \\
   * >> k = convex_product_structure(i, j); \\
   */
  //@{
    //@Include: simplex_structure.C
    //@Include: convex_product_structure.C
  //@} 

/* *********************************************************************** */
/*                                                                         */
/*  geometric transformations commands                                     */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Geometric Transformations
   * A geometric transformation is an application which maps a reference
   * element to a real element. Basic geometric transformations are 
   * transformations of degree k on a simplex and tensorial product of such
   * transformations.
   * Exemple : \\
   * >> i = simplex_trans(2, 1); \\
   * >> j = simplex_trans(1, 1); \\
   * >> k = convex_product_trans(i, j); \\
   */
  //@{
    //@Include: simplex_trans.C
    //@Include: convex_product_trans.C
  //@} 

/* *********************************************************************** */
/*                                                                         */
/*  fem interpolation commands                                             */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Finite Element Method Interpolations
   * A fem interpolation is a description of a finite element method on a
   * reference element. Basic fem interpolations are 
   * classical interpolations of degree k on a simplex and tensorial product
   * of such interpolations.
   * Exemple : \\
   * >> i = PK_fem_interpolation(2, 1); \\
   * >> j = PK_fem_interpolation(1, 1); \\
   * >> k = product_interpolation(i, j); \\
   */
  //@{
    //@Include: PK_fem_interpolation.C
    //@Include: QK_fem_interpolation.C
    //@Include: product_interpolation.C
  //@} 

/* *********************************************************************** */
/*                                                                         */
/*  finite element methods commands                                        */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Finite Element Method
   * A finite element methods it the set of a finite element interpolation, 
   * a geometric transformation and a integration method.
   * Exemple : \\
   * >> i = fem_exact_linear_PK(3, 2); \\
   */
  //@{
    //@Include: fem_exact_linear_PK.C
  //@}


/* *********************************************************************** */
/*                                                                         */
/*  Elementary matrices types commands                                     */
/*                                                                         */
/* *********************************************************************** */

  /**@name Commands on Elementary Matrices Types
   * An elementary matrices type describes a product of shape functions, or
   * gradients or hessians of shape functions to be integrate on elements.
   * Exemple : \\
   * >> pfi = PK_fem_interpolation(3, 2); \\
   * >> i = mat_elem_grad(pfi); \\
   * >> j = mat_elem_grad(pfi); \\
   * >> k = mat_elem_product(i, j); \\
   */
  //@{
    //@Include: mat_elem_base.C
    //@Include: mat_elem_grad.C
    //@Include: mat_elem_hess.C
    //@Include: mat_elem_product.C
  //@}



/* *********************************************************************** */
/*                                                                         */
/*   mesh commands                                                         */
/*                                                                         */
/* *********************************************************************** */

/**@name commands on Meshes
   * An mesh variable represent a multi-dimensional mesh, composed of possibly
   * element of different dimension or shape. The mesh as a proper dimension,
   * which is the dimension of its nodes. Elements has at most the dimension
   * the mesh. This proper dimension correspond to the dimension of the first
   * point added to the mesh.
   * Exemple : \\
   * >> i = new_mesh;  \\
   * >> add_point_to_mesh(i, [0.1 0.2 0.4]); \\
   * >> add_point_to_mesh(i, [0.1 0.2 0.5], [0.1 0.3 0.5]); \\
   * >> del_mesh(i); \\
   */
  //@{
    //@Include: new_mesh.C
    //@Include: del_mesh.C
    //@Include: clear_all_mesh.C
    //@Include: add_point_to_mesh.C
    //@Include: sup_point_to_mesh.C
    //@Include: add_convex_to_mesh.C
    //@Include: sup_convex_to_mesh.C
    //@Include: mesh_from_pdetool.C
    //@Include: prismatic_mesh.C
    //@Include: curved_mesh_C.C
    //@Include: mesh_translation.C
    //@Include: mesh_transformation.C
    /**@name H = draw_mesh(i)
     * draw a mesh. For meshes in dimension 1, 2 or 3.
     */
     //@{
     //@} 
  //@} 


/* *********************************************************************** */
/*                                                                         */
/*   mesh fem commands                                                     */
/*                                                                         */
/* *********************************************************************** */

/**@name commands on Mesh Fem
   * An mesh fem variable represent a description of a complete finite element
   * method on a given mesh.
   * Exemple : \\
   * >> i = new_mesh;  \\
   * >> j = new_mesh_fem(i); \\
   * >> del_mesh_fem(j); \\
   * >> del_mesh(i); \\
   */
  //@{
    //@Include: new_mesh_fem.C
    //@Include: del_mesh_fem.C
    //@Include: clear_all_mesh_fem.C
    //@Include: set_finite_element.C
    //@Include: mat_elem.C
    //@Include: mat_elem_on_face.C
  //@} 






//@}

/**@name Exemples
 * blabla
 */
//@{

//@}




#endif /* __MATLABCOM_H                                                    */
